/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.EventLogger;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.SubscriptionLink;
import io.aeron.shadow.net.bytebuddy.asm.Advice;

class CleanupInterceptor {
    CleanupInterceptor() {
    }

    static class CleanupSubscriptionLink {
        CleanupSubscriptionLink() {
        }

        @Advice.OnMethodEnter
        static void cleanupSubscriptionLink(SubscriptionLink link) {
            EventLogger.LOGGER.logSubscriptionRemoval(link.channel(), link.streamId(), link.registrationId());
        }
    }

    static class CleanupPublication {
        CleanupPublication() {
        }

        @Advice.OnMethodEnter
        static void cleanupPublication(NetworkPublication publication) {
            EventLogger.LOGGER.logPublicationRemoval(publication.channel(), publication.sessionId(), publication.streamId());
        }
    }

    static class CleanupImage {
        CleanupImage() {
        }

        @Advice.OnMethodEnter
        static void cleanupImageInterceptor(PublicationImage image) {
            EventLogger.LOGGER.logImageRemoval(image.channel(), image.sessionId(), image.streamId(), image.correlationId());
        }
    }
}

