/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.agent;

import io.aeron.agent.EventCode;
import io.aeron.agent.EventLogger;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.shadow.net.bytebuddy.asm.Advice;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;

class ChannelEndpointInterceptor {
    ChannelEndpointInterceptor() {
    }

    public static class UdpChannelTransportInterceptor {

        public static class ReceiveHook {
            @Advice.OnMethodEnter
            public static void receiveHook(UnsafeBuffer buffer, int length, InetSocketAddress address) {
                EventLogger.LOGGER.logFrameIn(buffer, 0, length, address);
            }
        }

        public static class SendHook {
            @Advice.OnMethodEnter
            public static void sendHook(ByteBuffer buffer, InetSocketAddress address) {
                EventLogger.LOGGER.logFrameOut(buffer, address);
            }
        }
    }

    public static class ReceiverProxyInterceptor {

        public static class CloseReceiveChannelEndpoint {
            @Advice.OnMethodEnter
            public static void closeReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
                EventLogger.LOGGER.logChannelCreated(EventCode.RECEIVE_CHANNEL_CLOSE, channelEndpoint.udpChannel().description());
            }
        }

        public static class RegisterReceiveChannelEndpoint {
            @Advice.OnMethodEnter
            public static void registerReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
                EventLogger.LOGGER.logChannelCreated(EventCode.RECEIVE_CHANNEL_CREATION, channelEndpoint.udpChannel().description());
            }
        }
    }

    public static class SenderProxyInterceptor {

        public static class CloseSendChannelEndpoint {
            @Advice.OnMethodEnter
            public static void closeSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
                EventLogger.LOGGER.logChannelCreated(EventCode.SEND_CHANNEL_CLOSE, channelEndpoint.udpChannel().description());
            }
        }

        public static class RegisterSendChannelEndpoint {
            @Advice.OnMethodEnter
            public static void registerSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
                EventLogger.LOGGER.logChannelCreated(EventCode.SEND_CHANNEL_CREATION, channelEndpoint.udpChannel().description());
            }
        }
    }
}

