/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.ManagedResource;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBuffers
implements AutoCloseable,
ManagedResource {
    private static final EnumSet<StandardOpenOption> FILE_OPTIONS = EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];
    private long timeOfLastStateChangeNs;
    private int refCount;
    private final int termLength;
    private final FileChannel fileChannel;
    private final ByteBuffer[] termBuffers = new ByteBuffer[3];
    private final UnsafeBuffer logMetaDataBuffer;
    private final MappedByteBuffer[] mappedByteBuffers;

    public LogBuffers(String logFileName) {
        try {
            this.fileChannel = FileChannel.open(Paths.get(logFileName, new String[0]), FILE_OPTIONS, NO_ATTRIBUTES);
            long logLength = this.fileChannel.size();
            if (logLength < Integer.MAX_VALUE) {
                MappedByteBuffer mappedBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, logLength);
                mappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mappedByteBuffers = new MappedByteBuffer[]{mappedBuffer};
                this.logMetaDataBuffer = new UnsafeBuffer(mappedBuffer, (int)(logLength - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH), LogBufferDescriptor.LOG_META_DATA_LENGTH);
                int termLength = LogBufferDescriptor.termLength(this.logMetaDataBuffer);
                int pageSize = LogBufferDescriptor.pageSize(this.logMetaDataBuffer);
                LogBufferDescriptor.checkTermLength(termLength);
                LogBufferDescriptor.checkPageSize(pageSize);
                this.termLength = termLength;
                for (int i = 0; i < 3; ++i) {
                    int offset = i * termLength;
                    mappedBuffer.limit(offset + termLength).position(offset);
                    this.termBuffers[i] = mappedBuffer.slice();
                }
            } else {
                this.mappedByteBuffers = new MappedByteBuffer[4];
                int assumedTermLength = 0x40000000;
                long metaDataSectionOffset = 0xC0000000L;
                long metaDataMappingLength = logLength - 0xC0000000L;
                MappedByteBuffer metaDataMappedBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0xC0000000L, metaDataMappingLength);
                metaDataMappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mappedByteBuffers[3] = metaDataMappedBuffer;
                this.logMetaDataBuffer = new UnsafeBuffer(metaDataMappedBuffer, (int)metaDataMappingLength - LogBufferDescriptor.LOG_META_DATA_LENGTH, LogBufferDescriptor.LOG_META_DATA_LENGTH);
                int metaDataTermLength = LogBufferDescriptor.termLength(this.logMetaDataBuffer);
                int pageSize = LogBufferDescriptor.pageSize(this.logMetaDataBuffer);
                LogBufferDescriptor.checkPageSize(pageSize);
                if (metaDataTermLength != 0x40000000) {
                    throw new IllegalStateException("assumed term length 1073741824 does not match metadata: termLength=" + metaDataTermLength);
                }
                this.termLength = 0x40000000;
                for (int i = 0; i < 3; ++i) {
                    long position = 0x40000000L * (long)i;
                    MappedByteBuffer mappedBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, position, 0x40000000L);
                    mappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.mappedByteBuffers[i] = mappedBuffer;
                    this.termBuffers[i] = mappedBuffer;
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalStateException ex) {
            this.close();
            throw ex;
        }
    }

    public UnsafeBuffer[] duplicateTermBuffers() {
        UnsafeBuffer[] buffers = new UnsafeBuffer[3];
        for (int i = 0; i < 3; ++i) {
            buffers[i] = new UnsafeBuffer(this.termBuffers[i].duplicate().order(ByteOrder.LITTLE_ENDIAN));
        }
        return buffers;
    }

    public UnsafeBuffer metaDataBuffer() {
        return this.logMetaDataBuffer;
    }

    public FileChannel fileChannel() {
        return this.fileChannel;
    }

    @Override
    public void close() {
        CloseHelper.close(this.fileChannel);
        for (MappedByteBuffer buffer : this.mappedByteBuffers) {
            IoUtil.unmap(buffer);
        }
    }

    public int termLength() {
        return this.termLength;
    }

    public int incRef() {
        return ++this.refCount;
    }

    public int decRef() {
        return --this.refCount;
    }

    @Override
    public void timeOfLastStateChange(long timeNs) {
        this.timeOfLastStateChangeNs = timeNs;
    }

    @Override
    public long timeOfLastStateChange() {
        return this.timeOfLastStateChangeNs;
    }

    @Override
    public void delete() {
        this.close();
    }
}

