/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.LogBuffers;
import io.aeron.Subscription;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.Header;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.RawBlockHandler;
import io.aeron.logbuffer.TermBlockScanner;
import io.aeron.logbuffer.TermReader;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.agrona.BitUtil;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.Position;

public class Image {
    private final long correlationId;
    private final long joinPosition;
    private long finalPosition;
    private final int sessionId;
    private final int initialTermId;
    private final int termLengthMask;
    private final int positionBitsToShift;
    private boolean isEos;
    private volatile boolean isClosed;
    private final Position subscriberPosition;
    private final UnsafeBuffer[] termBuffers;
    private final Header header;
    private final ErrorHandler errorHandler;
    private final LogBuffers logBuffers;
    private final String sourceIdentity;
    private final Subscription subscription;

    public Image(Subscription subscription, int sessionId, Position subscriberPosition, LogBuffers logBuffers, ErrorHandler errorHandler, String sourceIdentity, long correlationId) {
        this.subscription = subscription;
        this.sessionId = sessionId;
        this.subscriberPosition = subscriberPosition;
        this.logBuffers = logBuffers;
        this.errorHandler = errorHandler;
        this.sourceIdentity = sourceIdentity;
        this.correlationId = correlationId;
        this.joinPosition = subscriberPosition.get();
        this.termBuffers = logBuffers.duplicateTermBuffers();
        int termLength = logBuffers.termLength();
        this.termLengthMask = termLength - 1;
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
        this.initialTermId = LogBufferDescriptor.initialTermId(logBuffers.metaDataBuffer());
        this.header = new Header(this.initialTermId, this.positionBitsToShift, this);
    }

    public int positionBitsToShift() {
        return this.positionBitsToShift;
    }

    public int termBufferLength() {
        return this.termLengthMask + 1;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public String sourceIdentity() {
        return this.sourceIdentity;
    }

    public int mtuLength() {
        return LogBufferDescriptor.mtuLength(this.logBuffers.metaDataBuffer());
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long joinPosition() {
        return this.joinPosition;
    }

    public long position() {
        if (this.isClosed) {
            return this.finalPosition;
        }
        return this.subscriberPosition.get();
    }

    public void position(long newPosition) {
        if (!this.isClosed) {
            this.validatePosition(newPosition);
            this.subscriberPosition.setOrdered(newPosition);
        }
    }

    public int subscriberPositionId() {
        return this.subscriberPosition.id();
    }

    public boolean isEndOfStream() {
        if (this.isClosed) {
            return this.isEos;
        }
        return this.subscriberPosition.get() >= LogBufferDescriptor.endOfStreamPosition(this.logBuffers.metaDataBuffer());
    }

    public FileChannel fileChannel() {
        return this.logBuffers.fileChannel();
    }

    public int poll(FragmentHandler fragmentHandler, int fragmentLimit) {
        if (this.isClosed) {
            return 0;
        }
        long position = this.subscriberPosition.get();
        return TermReader.read(this.activeTermBuffer(position), (int)position & this.termLengthMask, fragmentHandler, fragmentLimit, this.header, this.errorHandler, position, this.subscriberPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int controlledPoll(ControlledFragmentHandler handler, int fragmentLimit) {
        int initialOffset;
        int resultingOffset;
        if (this.isClosed) {
            return 0;
        }
        int fragmentsRead = 0;
        long initialPosition = this.subscriberPosition.get();
        UnsafeBuffer termBuffer = this.activeTermBuffer(initialPosition);
        int capacity = termBuffer.capacity();
        this.header.buffer(termBuffer);
        try {
            int alignedLength;
            for (resultingOffset = initialOffset = (int)initialPosition & this.termLengthMask; fragmentsRead < fragmentLimit && resultingOffset < capacity; resultingOffset += alignedLength) {
                int length = FrameDescriptor.frameLengthVolatile(termBuffer, resultingOffset);
                if (length <= 0) {
                } else {
                    int frameOffset = resultingOffset;
                    alignedLength = BitUtil.align(length, 32);
                    if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) continue;
                    this.header.offset(frameOffset);
                    ControlledFragmentHandler.Action action = handler.onFragment(termBuffer, frameOffset + 32, length - 32, this.header);
                    if (action == ControlledFragmentHandler.Action.ABORT) {
                        resultingOffset -= alignedLength;
                    } else {
                        ++fragmentsRead;
                        if (action != ControlledFragmentHandler.Action.BREAK) continue;
                    }
                }
                break;
            }
        }
        catch (Throwable t) {
            this.errorHandler.onError(t);
        }
        finally {
            long resultingPosition = initialPosition + (long)(resultingOffset - initialOffset);
            if (resultingPosition > initialPosition) {
                this.subscriberPosition.setOrdered(resultingPosition);
            }
        }
        return fragmentsRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int boundedControlledPoll(ControlledFragmentHandler handler, long maxPosition, int fragmentLimit) {
        int resultingOffset;
        int initialOffset;
        if (this.isClosed) {
            return 0;
        }
        int fragmentsRead = 0;
        long initialPosition = this.subscriberPosition.get();
        UnsafeBuffer termBuffer = this.activeTermBuffer(initialPosition);
        int endOffset = (int)Math.min((long)termBuffer.capacity(), maxPosition - initialPosition + (long)initialOffset);
        this.header.buffer(termBuffer);
        try {
            int alignedLength;
            for (resultingOffset = initialOffset = (int)initialPosition & this.termLengthMask; fragmentsRead < fragmentLimit && resultingOffset < endOffset; resultingOffset += alignedLength) {
                int length = FrameDescriptor.frameLengthVolatile(termBuffer, resultingOffset);
                if (length <= 0) {
                } else {
                    int frameOffset = resultingOffset;
                    alignedLength = BitUtil.align(length, 32);
                    if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) continue;
                    this.header.offset(frameOffset);
                    ControlledFragmentHandler.Action action = handler.onFragment(termBuffer, frameOffset + 32, length - 32, this.header);
                    if (action == ControlledFragmentHandler.Action.ABORT) {
                        resultingOffset -= alignedLength;
                    } else {
                        ++fragmentsRead;
                        if (action != ControlledFragmentHandler.Action.BREAK) continue;
                    }
                }
                break;
            }
        }
        catch (Throwable t) {
            this.errorHandler.onError(t);
        }
        finally {
            long resultingPosition = initialPosition + (long)(resultingOffset - initialOffset);
            if (resultingPosition > initialPosition) {
                this.subscriberPosition.setOrdered(resultingPosition);
            }
        }
        return fragmentsRead;
    }

    public long controlledPeek(long initialPosition, ControlledFragmentHandler handler, long limitPosition) {
        int initialOffset;
        if (this.isClosed) {
            return 0L;
        }
        this.validatePosition(initialPosition);
        int offset = initialOffset = (int)initialPosition & this.termLengthMask;
        long position = initialPosition;
        UnsafeBuffer termBuffer = this.activeTermBuffer(initialPosition);
        int capacity = termBuffer.capacity();
        this.header.buffer(termBuffer);
        long resultingPosition = initialPosition;
        try {
            int length;
            while (position < limitPosition && offset < capacity && (length = FrameDescriptor.frameLengthVolatile(termBuffer, offset)) > 0) {
                int frameOffset = offset;
                int alignedLength = BitUtil.align(length, 32);
                offset += alignedLength;
                if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) {
                    initialOffset = offset;
                    resultingPosition = position += (long)(offset - initialOffset);
                    continue;
                }
                this.header.offset(frameOffset);
                ControlledFragmentHandler.Action action = handler.onFragment(termBuffer, frameOffset + 32, length - 32, this.header);
                if (action != ControlledFragmentHandler.Action.ABORT) {
                    position += (long)(offset - initialOffset);
                    initialOffset = offset;
                    if ((this.header.flags() & 0x40) == 64) {
                        resultingPosition = position;
                    }
                    if (action != ControlledFragmentHandler.Action.BREAK) continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            this.errorHandler.onError(t);
        }
        return resultingPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int blockPoll(BlockHandler handler, int blockLengthLimit) {
        if (this.isClosed) {
            return 0;
        }
        long position = this.subscriberPosition.get();
        int termOffset = (int)position & this.termLengthMask;
        UnsafeBuffer termBuffer = this.activeTermBuffer(position);
        int limitOffset = Math.min(termOffset + blockLengthLimit, termBuffer.capacity());
        int resultingOffset = TermBlockScanner.scan(termBuffer, termOffset, limitOffset);
        int length = resultingOffset - termOffset;
        if (resultingOffset > termOffset) {
            try {
                int termId = termBuffer.getInt(termOffset + 20, ByteOrder.LITTLE_ENDIAN);
                handler.onBlock(termBuffer, termOffset, length, this.sessionId, termId);
            }
            catch (Throwable t) {
                this.errorHandler.onError(t);
            }
            finally {
                this.subscriberPosition.setOrdered(position + (long)length);
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rawPoll(RawBlockHandler handler, int blockLengthLimit) {
        if (this.isClosed) {
            return 0;
        }
        long position = this.subscriberPosition.get();
        int termOffset = (int)position & this.termLengthMask;
        int activeIndex = LogBufferDescriptor.indexByPosition(position, this.positionBitsToShift);
        UnsafeBuffer termBuffer = this.termBuffers[activeIndex];
        int capacity = termBuffer.capacity();
        int limitOffset = Math.min(termOffset + blockLengthLimit, capacity);
        int resultingOffset = TermBlockScanner.scan(termBuffer, termOffset, limitOffset);
        int length = resultingOffset - termOffset;
        if (resultingOffset > termOffset) {
            try {
                long fileOffset = (long)capacity * (long)activeIndex + (long)termOffset;
                int termId = termBuffer.getInt(termOffset + 20, ByteOrder.LITTLE_ENDIAN);
                handler.onBlock(this.logBuffers.fileChannel(), fileOffset, termBuffer, termOffset, length, this.sessionId, termId);
            }
            catch (Throwable t) {
                this.errorHandler.onError(t);
            }
            finally {
                this.subscriberPosition.setOrdered(position + (long)length);
            }
        }
        return length;
    }

    private UnsafeBuffer activeTermBuffer(long position) {
        return this.termBuffers[LogBufferDescriptor.indexByPosition(position, this.positionBitsToShift)];
    }

    private void validatePosition(long newPosition) {
        long currentPosition = this.subscriberPosition.get();
        long limitPosition = currentPosition - (currentPosition & (long)this.termLengthMask) + (long)this.termLengthMask + 1L;
        if (newPosition < currentPosition || newPosition > limitPosition) {
            throw new IllegalArgumentException(newPosition + " newPosition out of range " + currentPosition + "-" + limitPosition);
        }
        if (0L != (newPosition & 0x1FL)) {
            throw new IllegalArgumentException(newPosition + " newPosition not aligned to FRAME_ALIGNMENT");
        }
    }

    LogBuffers logBuffers() {
        return this.logBuffers;
    }

    void close() {
        this.finalPosition = this.subscriberPosition.getVolatile();
        this.isEos = this.finalPosition >= LogBufferDescriptor.endOfStreamPosition(this.logBuffers.metaDataBuffer());
        this.isClosed = true;
    }

    public String toString() {
        return "Image{correlationId=" + this.correlationId + ", joinPosition=" + this.joinPosition + ", sessionId=" + this.sessionId + ", initialTermId=" + this.initialTermId + ", isEos=" + this.isEos + ", sourceIdentity='" + this.sourceIdentity + '\'' + ", subscription=" + this.subscription + ", position=" + this.position() + '}';
    }
}

