/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj.util;

import com.wavesplatform.crypto.Hash;
import com.wavesplatform.crypto.base.Base58;
import com.wavesplatform.wavesj.Node;
import com.wavesplatform.wavesj.exceptions.NodeException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;
import org.web3j.utils.Numeric;

public class WavesEthConverter {
    public static String wavesToEthAddress(String address) {
        byte[] wavesAddress = Base58.decode((String)address);
        byte[] ethAddress = Arrays.copyOfRange(wavesAddress, 2, 22);
        return Numeric.toHexString((byte[])ethAddress);
    }

    public static String ethToWavesAddress(String address, byte chainId) {
        byte[] pkHash = Arrays.copyOfRange(Hex.decode((String)address.substring(2)), 0, 20);
        byte[] prefixBytes = new byte[]{1, chainId};
        byte[] checkSumBytes = ArrayUtils.addAll((byte[])prefixBytes, (byte[])pkHash);
        byte[] checkSum = Hash.keccak((byte[])Hash.blake((byte[])checkSumBytes));
        byte[] wavesBytes = ArrayUtils.addAll((byte[])ArrayUtils.addAll((byte[])prefixBytes, (byte[])pkHash), (byte[])Arrays.copyOfRange(checkSum, 0, 4));
        return Base58.encode((byte[])wavesBytes);
    }

    public static String wavesToEthAsset(String asset) {
        byte[] decode = Arrays.copyOfRange(Base58.decode((String)asset), 0, 20);
        return "0x" + Hex.toHexString((byte[])decode);
    }

    public static String ethToWavesAsset(Node node, String asset) throws NodeException, IOException {
        return node.ethToWavesAsset(asset);
    }
}

