/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj.json.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.wavesplatform.transactions.BurnTransaction;
import com.wavesplatform.transactions.CreateAliasTransaction;
import com.wavesplatform.transactions.DataTransaction;
import com.wavesplatform.transactions.EthereumTransaction;
import com.wavesplatform.transactions.ExchangeTransaction;
import com.wavesplatform.transactions.GenesisTransaction;
import com.wavesplatform.transactions.InvokeScriptTransaction;
import com.wavesplatform.transactions.IssueTransaction;
import com.wavesplatform.transactions.LeaseCancelTransaction;
import com.wavesplatform.transactions.LeaseTransaction;
import com.wavesplatform.transactions.MassTransferTransaction;
import com.wavesplatform.transactions.PaymentTransaction;
import com.wavesplatform.transactions.ReissueTransaction;
import com.wavesplatform.transactions.SetAssetScriptTransaction;
import com.wavesplatform.transactions.SetScriptTransaction;
import com.wavesplatform.transactions.SponsorFeeTransaction;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.TransferTransaction;
import com.wavesplatform.transactions.UpdateAssetInfoTransaction;
import com.wavesplatform.wavesj.ApplicationStatus;
import com.wavesplatform.wavesj.LeaseInfo;
import com.wavesplatform.wavesj.LeaseStatus;
import com.wavesplatform.wavesj.StateChanges;
import com.wavesplatform.wavesj.info.BurnTransactionInfo;
import com.wavesplatform.wavesj.info.CreateAliasTransactionInfo;
import com.wavesplatform.wavesj.info.DataTransactionInfo;
import com.wavesplatform.wavesj.info.EthereumTransactionInfo;
import com.wavesplatform.wavesj.info.ExchangeTransactionInfo;
import com.wavesplatform.wavesj.info.GenesisTransactionInfo;
import com.wavesplatform.wavesj.info.InvokeScriptTransactionInfo;
import com.wavesplatform.wavesj.info.IssueTransactionInfo;
import com.wavesplatform.wavesj.info.LeaseCancelTransactionInfo;
import com.wavesplatform.wavesj.info.LeaseTransactionInfo;
import com.wavesplatform.wavesj.info.MassTransferTransactionInfo;
import com.wavesplatform.wavesj.info.PaymentTransactionInfo;
import com.wavesplatform.wavesj.info.ReissueTransactionInfo;
import com.wavesplatform.wavesj.info.SetAssetScriptTransactionInfo;
import com.wavesplatform.wavesj.info.SetScriptTransactionInfo;
import com.wavesplatform.wavesj.info.SponsorFeeTransactionInfo;
import com.wavesplatform.wavesj.info.TransactionInfo;
import com.wavesplatform.wavesj.info.TransferTransactionInfo;
import com.wavesplatform.wavesj.info.UpdateAssetInfoTransactionInfo;
import java.io.IOException;

public class TransactionInfoDeser
extends JsonDeserializer<TransactionInfo> {
    public TransactionInfo deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = p.getCodec();
        JsonNode json = (JsonNode)codec.readTree(p);
        Transaction tx = Transaction.fromJson((String)json.toString());
        ApplicationStatus status = (ApplicationStatus)((Object)codec.treeToValue((TreeNode)json.get("applicationStatus"), ApplicationStatus.class));
        int height = json.get("height").asInt();
        if (tx instanceof GenesisTransaction) {
            return new GenesisTransactionInfo((GenesisTransaction)tx, status, height);
        }
        if (tx instanceof PaymentTransaction) {
            return new PaymentTransactionInfo((PaymentTransaction)tx, status, height);
        }
        if (tx instanceof IssueTransaction) {
            return new IssueTransactionInfo((IssueTransaction)tx, status, height);
        }
        if (tx instanceof TransferTransaction) {
            return new TransferTransactionInfo((TransferTransaction)tx, status, height);
        }
        if (tx instanceof ReissueTransaction) {
            return new ReissueTransactionInfo((ReissueTransaction)tx, status, height);
        }
        if (tx instanceof BurnTransaction) {
            return new BurnTransactionInfo((BurnTransaction)tx, status, height);
        }
        if (tx instanceof ExchangeTransaction) {
            return new ExchangeTransactionInfo((ExchangeTransaction)tx, status, height);
        }
        if (tx instanceof LeaseTransaction) {
            return new LeaseTransactionInfo((LeaseTransaction)tx, status, height, (LeaseStatus)((Object)codec.treeToValue((TreeNode)json.get("status"), LeaseStatus.class)));
        }
        if (tx instanceof LeaseCancelTransaction) {
            return new LeaseCancelTransactionInfo((LeaseCancelTransaction)tx, status, height, (LeaseInfo)codec.treeToValue((TreeNode)json.get("lease"), LeaseInfo.class));
        }
        if (tx instanceof CreateAliasTransaction) {
            return new CreateAliasTransactionInfo((CreateAliasTransaction)tx, status, height);
        }
        if (tx instanceof DataTransaction) {
            return new DataTransactionInfo((DataTransaction)tx, status, height);
        }
        if (tx instanceof MassTransferTransaction) {
            return new MassTransferTransactionInfo((MassTransferTransaction)tx, status, height);
        }
        if (tx instanceof SetScriptTransaction) {
            return new SetScriptTransactionInfo((SetScriptTransaction)tx, status, height);
        }
        if (tx instanceof SponsorFeeTransaction) {
            return new SponsorFeeTransactionInfo((SponsorFeeTransaction)tx, status, height);
        }
        if (tx instanceof SetAssetScriptTransaction) {
            return new SetAssetScriptTransactionInfo((SetAssetScriptTransaction)tx, status, height);
        }
        if (tx instanceof InvokeScriptTransaction) {
            return new InvokeScriptTransactionInfo((InvokeScriptTransaction)tx, status, height, (StateChanges)codec.treeToValue((TreeNode)json.get("stateChanges"), StateChanges.class));
        }
        if (tx instanceof UpdateAssetInfoTransaction) {
            return new UpdateAssetInfoTransactionInfo((UpdateAssetInfoTransaction)tx, status, height);
        }
        if (tx instanceof EthereumTransaction) {
            return new EthereumTransactionInfo((EthereumTransaction)tx, status, height, this.stateChangesFromJson(codec, json), json.get("bytes").asText());
        }
        throw new IOException("Can't parse transaction info: " + json.toString());
    }

    private StateChanges stateChangesFromJson(ObjectCodec codec, JsonNode json) throws JsonProcessingException {
        return json.get("payload") != null ? (StateChanges)codec.treeToValue((TreeNode)json.get("payload").get("stateChanges"), StateChanges.class) : null;
    }
}

