/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj.json.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.wavesplatform.transactions.invocation.Arg;
import com.wavesplatform.transactions.invocation.BinaryArg;
import com.wavesplatform.transactions.invocation.BooleanArg;
import com.wavesplatform.transactions.invocation.Function;
import com.wavesplatform.transactions.invocation.IntegerArg;
import com.wavesplatform.transactions.invocation.ListArg;
import com.wavesplatform.transactions.invocation.StringArg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FunctionDeser
extends JsonDeserializer<Function> {
    public Function deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = p.getCodec();
        JsonNode json = (JsonNode)codec.readTree(p);
        if (json.isNull()) {
            return Function.asDefault();
        }
        String name = json.get("function").asText();
        List<Arg> args = FunctionDeser.parseArgsList(json.get("args"));
        return Function.as((String)name, args);
    }

    public static List<Arg> parseArgsList(JsonNode list) {
        ArrayList<Arg> args = new ArrayList<Arg>();
        for (int i = 0; i < list.size(); ++i) {
            JsonNode arg = list.get(i);
            if ("String".equals(arg.get("type").asText())) {
                args.add((Arg)StringArg.as((String)arg.get("value").asText()));
                continue;
            }
            if ("Int".equals(arg.get("type").asText())) {
                args.add((Arg)IntegerArg.as((long)arg.get("value").asLong()));
                continue;
            }
            if ("Boolean".equals(arg.get("type").asText())) {
                args.add((Arg)BooleanArg.as((boolean)arg.get("value").asBoolean()));
                continue;
            }
            if ("ByteVector".equals(arg.get("type").asText())) {
                args.add((Arg)BinaryArg.as((String)arg.get("value").asText()));
                continue;
            }
            if (!"List".equals(arg.get("type").asText())) continue;
            args.add((Arg)ListArg.as(FunctionDeser.parseArgsList(arg.get("value"))));
        }
        return args;
    }
}

