/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj.info;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.wavesj.ApplicationStatus;
import com.wavesplatform.wavesj.Common;
import java.util.Objects;

public class TransactionWithStatus {
    private final Transaction tx;
    private final ApplicationStatus applicationStatus;

    public TransactionWithStatus(Transaction tx, ApplicationStatus applicationStatus) {
        this.tx = Common.notNull(tx, "Transaction");
        this.applicationStatus = applicationStatus == null ? ApplicationStatus.SUCCEEDED : applicationStatus;
    }

    public ApplicationStatus applicationStatus() {
        return this.applicationStatus;
    }

    public Transaction tx() {
        return this.tx;
    }

    public <T extends Transaction> T tx(Class<T> clazz) {
        return (T)this.tx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionWithStatus that = (TransactionWithStatus)o;
        return Objects.equals(this.tx, that.tx) && this.applicationStatus == that.applicationStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tx, this.applicationStatus});
    }

    public String toString() {
        return "TransactionWithStatus{tx=" + this.tx + ", applicationStatus=" + (Object)((Object)this.applicationStatus) + '}';
    }
}

