/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.wavesj.Common;
import java.util.Objects;

public class ScriptTransfer {
    private final Recipient recipient;
    private final long amount;
    private final AssetId assetId;

    @JsonCreator
    public ScriptTransfer(@JsonProperty(value="address") Recipient recipient, @JsonProperty(value="amount") long amount, @JsonProperty(value="asset") AssetId assetId) {
        this.recipient = Common.notNull(recipient, "Recipient");
        this.amount = amount;
        this.assetId = assetId == null ? AssetId.WAVES : assetId;
    }

    public ScriptTransfer(Recipient recipient, Amount amount) {
        this(recipient, amount.value(), amount.assetId());
    }

    public Recipient recipient() {
        return this.recipient;
    }

    public long amount() {
        return this.amount;
    }

    public AssetId assetId() {
        return this.assetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptTransfer that = (ScriptTransfer)o;
        return this.amount == that.amount && Objects.equals(this.recipient, that.recipient) && Objects.equals(this.assetId, that.assetId);
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.amount, this.assetId);
    }

    public String toString() {
        return "ScriptTransfer{recipient=" + this.recipient + ", amount=" + this.amount + ", assetId=" + this.assetId + '}';
    }
}

