/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavesplatform.transactions.common.Base64String;
import com.wavesplatform.wavesj.Common;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ScriptInfo {
    private final Base64String script;
    private final int complexity;
    private final int verifierComplexity;
    private final Map<String, Integer> callableComplexities;
    private final long extraFee;

    @JsonCreator
    public ScriptInfo(@JsonProperty(value="script") Base64String script, @JsonProperty(value="complexity") int complexity, @JsonProperty(value="verifierComplexity") int verifierComplexity, @JsonProperty(value="callableComplexities") Map<String, Integer> callableComplexities, @JsonProperty(value="extraFee") long extraFee) {
        this.script = script == null ? Base64String.empty() : script;
        this.complexity = complexity;
        this.verifierComplexity = verifierComplexity;
        this.callableComplexities = Common.notNull(callableComplexities, "CallableComplexities");
        this.extraFee = extraFee;
    }

    public Base64String script() {
        return this.script;
    }

    public int complexity() {
        return this.complexity;
    }

    public int verifierComplexity() {
        return this.verifierComplexity;
    }

    public Map<String, Integer> callableComplexities() {
        return this.callableComplexities;
    }

    public long extraFee() {
        return this.extraFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptInfo that = (ScriptInfo)o;
        return this.complexity == that.complexity && this.verifierComplexity == that.verifierComplexity && this.extraFee == that.extraFee && this.script.equals((Object)that.script) && this.callableComplexities.equals(that.callableComplexities);
    }

    public int hashCode() {
        return Objects.hash(this.script, this.complexity, this.verifierComplexity, this.callableComplexities, this.extraFee);
    }

    public String toString() {
        String callables = this.callableComplexities.keySet().stream().map(key -> key + "=" + this.callableComplexities.get(key)).collect(Collectors.joining(", ", "{", "}"));
        return "ScriptInfo{script='" + this.script + '\'' + ", complexity=" + this.complexity + ", verifierComplexity=" + this.verifierComplexity + ", callableComplexities=" + callables + ", extraFee=" + this.extraFee + '}';
    }
}

