/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavesplatform.transactions.common.Base64String;
import com.wavesplatform.wavesj.Common;
import java.util.Objects;

public class ScriptDetails {
    private final Base64String script;
    private final int complexity;

    @JsonCreator
    public ScriptDetails(@JsonProperty(value="script") String script, @JsonProperty(value="scriptComplexity") int complexity) {
        this.script = new Base64String(Common.notNull(script, "Script"));
        this.complexity = complexity;
    }

    public Base64String script() {
        return this.script;
    }

    public int complexity() {
        return this.complexity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptDetails that = (ScriptDetails)o;
        return this.complexity == that.complexity && Objects.equals(this.script, that.script);
    }

    public int hashCode() {
        return Objects.hash(this.script, this.complexity);
    }

    public String toString() {
        return "ScriptDetails{script='" + this.script + '\'' + ", complexity=" + this.complexity + '}';
    }
}

