/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.common.Alias;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base58String;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.data.DataEntry;
import com.wavesplatform.transactions.serializers.json.JsonSerializer;
import com.wavesplatform.wavesj.ArgMeta;
import com.wavesplatform.wavesj.AssetBalance;
import com.wavesplatform.wavesj.AssetDetails;
import com.wavesplatform.wavesj.AssetDistribution;
import com.wavesplatform.wavesj.Balance;
import com.wavesplatform.wavesj.BalanceDetails;
import com.wavesplatform.wavesj.Block;
import com.wavesplatform.wavesj.BlockHeaders;
import com.wavesplatform.wavesj.BlockchainRewards;
import com.wavesplatform.wavesj.HistoryBalance;
import com.wavesplatform.wavesj.LeaseInfo;
import com.wavesplatform.wavesj.Profile;
import com.wavesplatform.wavesj.ScriptInfo;
import com.wavesplatform.wavesj.ScriptMeta;
import com.wavesplatform.wavesj.Status;
import com.wavesplatform.wavesj.TransactionStatus;
import com.wavesplatform.wavesj.Validation;
import com.wavesplatform.wavesj.exceptions.NodeException;
import com.wavesplatform.wavesj.info.TransactionInfo;
import com.wavesplatform.wavesj.json.TypeRef;
import com.wavesplatform.wavesj.json.WavesJMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;

public class Node {
    private final byte chainId;
    private final HttpClient client;
    private final URI uri;
    private final WavesJMapper mapper;
    private final int blockInterval = 60;

    public Node(URI uri, HttpClient httpClient) throws IOException, NodeException {
        this.uri = uri;
        this.client = httpClient;
        this.mapper = new WavesJMapper();
        this.chainId = this.getAddresses().get(0).chainId();
        WavesConfig.chainId((byte)this.chainId);
    }

    public Node(String url, HttpClient httpClient) throws URISyntaxException, IOException, NodeException {
        this(new URI(url), httpClient);
    }

    public Node(Profile profile, HttpClient httpClient) throws IOException, NodeException {
        this(profile.uri(), httpClient);
    }

    public Node(URI uri) throws IOException, NodeException {
        this.uri = uri;
        this.client = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).setCookieSpec("standard").build()).build();
        this.mapper = new WavesJMapper();
        this.chainId = this.getAddresses().get(0).chainId();
        WavesConfig.chainId((byte)this.chainId);
    }

    public Node(String url) throws URISyntaxException, IOException, NodeException {
        this(new URI(url));
    }

    public Node(Profile profile) throws IOException, NodeException {
        this(profile.uri());
    }

    public byte chainId() {
        return this.chainId;
    }

    public HttpClient client() {
        return this.client;
    }

    public URI uri() {
        return this.uri;
    }

    public List<Address> getAddresses() throws IOException, NodeException {
        return this.asType(this.get("/addresses"), TypeRef.ADDRESSES);
    }

    public List<Address> getAddresses(int fromIndex, int toIndex) throws IOException, NodeException {
        return this.asType(this.get("/addresses/seq/" + fromIndex + "/" + toIndex), TypeRef.ADDRESSES);
    }

    public long getBalance(Address address) throws IOException, NodeException {
        return this.asJson(this.get("/addresses/balance/" + address.toString())).get("balance").asLong();
    }

    public long getBalance(Address address, int confirmations) throws IOException, NodeException {
        return this.asJson(this.get("/addresses/balance/" + address.toString() + "/" + confirmations)).get("balance").asLong();
    }

    public List<Balance> getBalances(List<Address> addresses) throws IOException, NodeException {
        ObjectNode jsonBody = JsonSerializer.JSON_MAPPER.createObjectNode();
        ArrayNode jsonAddresses = jsonBody.putArray("addresses");
        addresses.forEach(address -> jsonAddresses.add(address.toString()));
        StringEntity body = new StringEntity(JsonSerializer.JSON_MAPPER.writeValueAsString((Object)jsonBody), StandardCharsets.UTF_8);
        return this.asType(this.post("/addresses/balance").addHeader("Content-Type", "application/json").setEntity((HttpEntity)body), TypeRef.BALANCES);
    }

    public List<Balance> getBalances(List<Address> addresses, int height) throws IOException, NodeException {
        ObjectNode jsonBody = JsonSerializer.JSON_MAPPER.createObjectNode();
        ArrayNode jsonAddresses = jsonBody.putArray("addresses");
        addresses.forEach(address -> jsonAddresses.add(address.toString()));
        jsonBody.put("height", height);
        StringEntity body = new StringEntity(JsonSerializer.JSON_MAPPER.writeValueAsString((Object)jsonBody), StandardCharsets.UTF_8);
        return this.asType(this.post("/addresses/balance").addHeader("Content-Type", "application/json").setEntity((HttpEntity)body), TypeRef.BALANCES);
    }

    public BalanceDetails getBalanceDetails(Address address) throws IOException, NodeException {
        return this.asType(this.get("/addresses/balance/details/" + address.toString()), TypeRef.BALANCE_DETAILS);
    }

    public List<DataEntry> getData(Address address) throws IOException, NodeException {
        return this.asType(this.get("/addresses/data/" + address.toString()), TypeRef.DATA_ENTRIES);
    }

    public List<DataEntry> getData(Address address, List<String> keys) throws IOException, NodeException {
        ObjectNode jsonBody = JsonSerializer.JSON_MAPPER.createObjectNode();
        ArrayNode jsonKeys = jsonBody.putArray("keys");
        keys.forEach(arg_0 -> ((ArrayNode)jsonKeys).add(arg_0));
        StringEntity body = new StringEntity(JsonSerializer.JSON_MAPPER.writeValueAsString((Object)jsonBody), StandardCharsets.UTF_8);
        return this.asType(this.post("/addresses/data/" + address.toString()).addHeader("Content-Type", "application/json").setEntity((HttpEntity)body), TypeRef.DATA_ENTRIES);
    }

    public List<DataEntry> getData(Address address, Pattern regex) throws IOException, NodeException {
        return this.asType(this.get("/addresses/data/" + address.toString()).addParameter("matches", regex.toString()), TypeRef.DATA_ENTRIES);
    }

    public DataEntry getData(Address address, String key) throws IOException, NodeException {
        return this.asType(this.get("/addresses/data/" + address.toString() + "/" + key), TypeRef.DATA_ENTRY);
    }

    @Deprecated
    public long getEffectiveBalance(Address address) throws IOException, NodeException {
        return this.asJson(this.get("/addresses/effectiveBalance/" + address.toString())).get("balance").asLong();
    }

    @Deprecated
    public long getEffectiveBalance(Address address, int confirmations) throws IOException, NodeException {
        return this.asJson(this.get("/addresses/effectiveBalance/" + address.toString() + "/" + confirmations)).get("balance").asLong();
    }

    public ScriptInfo getScriptInfo(Address address) throws IOException, NodeException {
        return this.asType(this.get("/addresses/scriptInfo/" + address.toString()), TypeRef.SCRIPT_INFO);
    }

    public ScriptMeta getScriptMeta(Address address) throws IOException, NodeException {
        JsonNode json = this.asJson(this.get("/addresses/scriptInfo/" + address.toString() + "/meta"));
        if (json.hasNonNull("meta")) {
            return (ScriptMeta)this.mapper.convertValue(json.get("meta"), TypeRef.SCRIPT_META);
        }
        return new ScriptMeta(0, new HashMap<String, List<ArgMeta>>());
    }

    public List<Alias> getAliasesByAddress(Address address) throws IOException, NodeException {
        return this.asType(this.get("/alias/by-address/" + address.toString()), TypeRef.ALIASES);
    }

    public Address getAddressByAlias(Alias alias) throws IOException, NodeException {
        return Address.as((String)this.asJson(this.get("/alias/by-alias/" + alias.name())).get("address").asText());
    }

    public AssetDistribution getAssetDistribution(AssetId assetId, int height) throws IOException, NodeException {
        return this.getAssetDistribution(assetId, height, 1000);
    }

    public AssetDistribution getAssetDistribution(AssetId assetId, int height, int limit) throws IOException, NodeException {
        return this.getAssetDistribution(assetId, height, limit, null);
    }

    public AssetDistribution getAssetDistribution(AssetId assetId, int height, int limit, Address after) throws IOException, NodeException {
        RequestBuilder request = this.get("/assets/" + assetId.toString() + "/distribution/" + height + "/limit/" + limit);
        if (after != null) {
            request.addParameter("after", after.toString());
        }
        return this.asType(request, TypeRef.ASSET_DISTRIBUTION);
    }

    public List<AssetBalance> getAssetsBalance(Address address) throws IOException, NodeException {
        return (List)this.mapper.readerFor(TypeRef.ASSET_BALANCES).readValue(this.asJson(this.get("/assets/balance/" + address.toString())).get("balances"));
    }

    public long getAssetBalance(Address address, AssetId assetId) throws IOException, NodeException {
        return this.asJson(this.get("/assets/balance/" + address.toString() + "/" + assetId.toString())).get("balance").asLong();
    }

    public AssetDetails getAssetDetails(AssetId assetId) throws IOException, NodeException {
        return this.asType(this.get("/assets/details/" + assetId.toString()).addParameter("full", "true"), TypeRef.ASSET_DETAILS);
    }

    public List<AssetDetails> getAssetsDetails(List<AssetId> assetIds) throws IOException, NodeException {
        RequestBuilder request = this.get("/assets/details").addParameter("full", "true");
        assetIds.forEach(id -> request.addParameter("id", id.toString()));
        return this.asType(request, TypeRef.ASSETS_DETAILS);
    }

    public List<AssetDetails> getNft(Address address) throws IOException, NodeException {
        return this.getNft(address, 1000);
    }

    public List<AssetDetails> getNft(Address address, int limit) throws IOException, NodeException {
        return this.getNft(address, limit, null);
    }

    public List<AssetDetails> getNft(Address address, int limit, AssetId after) throws IOException, NodeException {
        RequestBuilder request = this.get("/assets/nft/" + address.toString() + "/limit/" + limit);
        if (after != null) {
            request.addParameter("after", after.toString());
        }
        return this.asType(request, TypeRef.ASSETS_DETAILS);
    }

    public BlockchainRewards getBlockchainRewards() throws IOException, NodeException {
        return this.asType(this.get("/blockchain/rewards"), TypeRef.BLOCKCHAIN_REWARDS);
    }

    public BlockchainRewards getBlockchainRewards(int height) throws IOException, NodeException {
        return this.asType(this.get("/blockchain/rewards/" + height), TypeRef.BLOCKCHAIN_REWARDS);
    }

    public int getHeight() throws IOException, NodeException {
        return this.asJson(this.get("/blocks/height")).get("height").asInt();
    }

    public int getBlockHeight(Base58String blockId) throws IOException, NodeException {
        return this.asJson(this.get("/blocks/height/" + blockId.toString())).get("height").asInt();
    }

    public int getBlockHeight(long timestamp) throws IOException, NodeException {
        return this.asJson(this.get("/blocks/heightByTimestamp/" + timestamp)).get("height").asInt();
    }

    public int getBlocksDelay(Base58String startBlockId, int blocksNum) throws IOException, NodeException {
        return this.asJson(this.get("/blocks/delay/" + startBlockId.toString() + "/" + blocksNum)).get("delay").asInt();
    }

    public BlockHeaders getBlockHeaders(int height) throws IOException, NodeException {
        return this.asType(this.get("/blocks/headers/at/" + height), TypeRef.BLOCK_HEADERS);
    }

    public BlockHeaders getBlockHeaders(Base58String blockId) throws IOException, NodeException {
        return this.asType(this.get("/blocks/headers/" + blockId.toString()), TypeRef.BLOCK_HEADERS);
    }

    public List<BlockHeaders> getBlocksHeaders(int fromHeight, int toHeight) throws IOException, NodeException {
        return this.asType(this.get("/blocks/headers/seq/" + fromHeight + "/" + toHeight), TypeRef.BLOCKS_HEADERS);
    }

    public BlockHeaders getLastBlockHeaders() throws IOException, NodeException {
        return this.asType(this.get("/blocks/headers/last"), TypeRef.BLOCK_HEADERS);
    }

    public Block getBlock(int height) throws IOException, NodeException {
        return this.asType(this.get("/blocks/at/" + height), TypeRef.BLOCK);
    }

    public Block getBlock(Base58String blockId) throws IOException, NodeException {
        return this.asType(this.get("/blocks/" + blockId.toString()), TypeRef.BLOCK);
    }

    public List<Block> getBlocks(int fromHeight, int toHeight) throws IOException, NodeException {
        return this.asType(this.get("/blocks/seq/" + fromHeight + "/" + toHeight), TypeRef.BLOCKS);
    }

    public Block getGenesisBlock() throws IOException, NodeException {
        return this.asType(this.get("/blocks/first"), TypeRef.BLOCK);
    }

    public Block getLastBlock() throws IOException, NodeException {
        return this.asType(this.get("/blocks/last"), TypeRef.BLOCK);
    }

    public List<Block> getBlocksGeneratedBy(Address generator, int fromHeight, int toHeight) throws IOException, NodeException {
        return this.asType(this.get("/blocks/address/" + generator.toString() + "/" + fromHeight + "/" + toHeight), TypeRef.BLOCKS);
    }

    public String getVersion() throws IOException, NodeException {
        return this.asJson(this.get("/node/version")).get("version").asText();
    }

    public List<HistoryBalance> getBalanceHistory(Address address) throws IOException, NodeException {
        return this.asType(this.get("/debug/balances/history/" + address.toString()), TypeRef.HISTORY_BALANCES);
    }

    public <T extends Transaction> Validation validateTransaction(T transaction) throws IOException, NodeException {
        return this.asType(this.post("/debug/validate").setEntity((HttpEntity)new StringEntity(transaction.toJson(), ContentType.APPLICATION_JSON)), TypeRef.VALIDATION);
    }

    public List<LeaseInfo> getActiveLeases(Address address) throws IOException, NodeException {
        return this.asType(this.get("/leasing/active/" + address.toString()), TypeRef.LEASES_INFO);
    }

    public LeaseInfo getLeaseInfo(Id leaseId) throws IOException, NodeException {
        return this.asType(this.get("/leasing/info/" + leaseId.toString()), TypeRef.LEASE_INFO);
    }

    public List<LeaseInfo> getLeasesInfo(List<Id> leaseIds) throws IOException, NodeException {
        ObjectNode jsonBody = JsonSerializer.JSON_MAPPER.createObjectNode();
        ArrayNode jsonIds = jsonBody.putArray("ids");
        leaseIds.forEach(id -> jsonIds.add(id.toString()));
        StringEntity body = new StringEntity(JsonSerializer.JSON_MAPPER.writeValueAsString((Object)jsonBody), StandardCharsets.UTF_8);
        return this.asType(this.post("/leasing/info").addHeader("Content-Type", "application/json").setEntity((HttpEntity)body), TypeRef.LEASES_INFO);
    }

    public List<LeaseInfo> getLeasesInfo(Id ... leaseIds) throws IOException, NodeException {
        return this.getLeasesInfo(Arrays.asList(leaseIds));
    }

    public <T extends Transaction> Amount calculateTransactionFee(T transaction) throws IOException, NodeException {
        JsonNode json = this.asJson(this.post("/transactions/calculateFee").setEntity((HttpEntity)new StringEntity(transaction.toJson(), ContentType.APPLICATION_JSON)));
        return Amount.of((long)json.get("feeAmount").asLong(), (AssetId)JsonSerializer.assetIdFromJson((JsonNode)json.get("feeAssetId")));
    }

    public <T extends Transaction> T broadcast(T transaction) throws IOException, NodeException {
        return (T)this.asType(this.post("/transactions/broadcast").setEntity((HttpEntity)new StringEntity(transaction.toJson(), ContentType.APPLICATION_JSON)), TypeRef.TRANSACTION);
    }

    public TransactionInfo getTransactionInfo(Id txId) throws IOException, NodeException {
        return this.asType(this.get("/transactions/info/" + txId.toString()), TypeRef.TRANSACTION_INFO);
    }

    public <T extends TransactionInfo> T getTransactionInfo(Id txId, Class<T> transactionInfoClass) throws IOException, NodeException {
        return (T)((TransactionInfo)transactionInfoClass.cast(this.asType(this.get("/transactions/info/" + txId.toString()), TypeRef.TRANSACTION_INFO)));
    }

    public List<TransactionInfo> getTransactionsByAddress(Address address) throws IOException, NodeException {
        return this.getTransactionsByAddress(address, 1000);
    }

    public List<TransactionInfo> getTransactionsByAddress(Address address, int limit) throws IOException, NodeException {
        return this.getTransactionsByAddress(address, limit, null);
    }

    public List<TransactionInfo> getTransactionsByAddress(Address address, int limit, Id afterTxId) throws IOException, NodeException {
        RequestBuilder request = this.get("/transactions/address/" + address.toString() + "/limit/" + limit);
        if (afterTxId != null) {
            request.addParameter("after", afterTxId.toString());
        }
        return (List)this.mapper.readerFor(TypeRef.TRANSACTIONS_INFO).readValue(this.asJson(request).get(0));
    }

    public TransactionStatus getTransactionStatus(Id txId) throws IOException, NodeException {
        return this.asType(this.get("/transactions/status").addParameter("id", txId.toString()), TypeRef.TRANSACTIONS_STATUS).get(0);
    }

    public List<TransactionStatus> getTransactionsStatus(List<Id> txIds) throws IOException, NodeException {
        ObjectNode jsonBody = JsonSerializer.JSON_MAPPER.createObjectNode();
        ArrayNode jsonIds = jsonBody.putArray("ids");
        txIds.forEach(id -> jsonIds.add(id.toString()));
        StringEntity body = new StringEntity(JsonSerializer.JSON_MAPPER.writeValueAsString((Object)jsonBody), StandardCharsets.UTF_8);
        return this.asType(this.post("/transactions/status").addHeader("Content-Type", "application/json").setEntity((HttpEntity)body), TypeRef.TRANSACTIONS_STATUS);
    }

    public List<TransactionStatus> getTransactionsStatus(Id ... txIds) throws IOException, NodeException {
        return this.getTransactionsStatus(Arrays.asList(txIds));
    }

    public Transaction getUnconfirmedTransaction(Id txId) throws IOException, NodeException {
        return this.asType(this.get("/transactions/unconfirmed/info/" + txId.toString()), TypeRef.TRANSACTION);
    }

    public List<Transaction> getUnconfirmedTransactions() throws IOException, NodeException {
        return this.asType(this.get("/transactions/unconfirmed"), TypeRef.TRANSACTIONS);
    }

    public int getUtxSize() throws IOException, NodeException {
        return this.asJson(this.get("/transactions/unconfirmed/size")).get("size").asInt();
    }

    public ScriptInfo compileScript(String source) throws IOException, NodeException {
        return this.compileScript(source, false);
    }

    public ScriptInfo compileScript(String source, boolean enableCompaction) throws IOException, NodeException {
        return this.asType(this.post("/utils/script/compileCode").addHeader("Content-Type", "text/plain").addParameter("compact", enableCompaction ? "true" : "false").setEntity((HttpEntity)new StringEntity(source, StandardCharsets.UTF_8)), TypeRef.SCRIPT_INFO);
    }

    public String ethToWavesAsset(String asset) throws NodeException, IOException {
        return this.asType(this.get("/eth/assets").addParameter("id", asset), TypeRef.ASSETS_DETAILS).get(0).assetId().encoded();
    }

    public TransactionInfo waitForTransaction(Id id, int waitingInSeconds) throws IOException {
        int pollingIntervalInMillis = 100;
        if (waitingInSeconds < 1) {
            throw new IllegalStateException("waitForTransaction: waiting value must be positive. Current: " + waitingInSeconds);
        }
        Exception lastException = null;
        for (long spentMillis = 0L; spentMillis < (long)waitingInSeconds * 1000L; spentMillis += (long)pollingIntervalInMillis) {
            try {
                return this.getTransactionInfo(id);
            }
            catch (Exception e) {
                lastException = e;
                try {
                    Thread.sleep(pollingIntervalInMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new IOException("Could not wait for transaction " + id + " in " + waitingInSeconds + " seconds", lastException);
    }

    public TransactionInfo waitForTransaction(Id id) throws IOException {
        return this.waitForTransaction(id, 60);
    }

    public <T extends TransactionInfo> T waitForTransaction(Id id, Class<T> infoClass) throws IOException {
        return (T)((TransactionInfo)infoClass.cast(this.waitForTransaction(id)));
    }

    public void waitForTransactions(List<Id> ids, int waitingInSeconds) throws IOException, NodeException {
        int pollingIntervalInMillis = 1000;
        if (waitingInSeconds < 1) {
            throw new IllegalStateException("waitForTransaction: waiting value must be positive. Current: " + waitingInSeconds);
        }
        Exception lastException = null;
        for (long spentMillis = 0L; spentMillis < (long)waitingInSeconds * 1000L; spentMillis += (long)pollingIntervalInMillis) {
            try {
                List<TransactionStatus> statuses = this.getTransactionsStatus(ids);
                if (!statuses.stream().allMatch(s -> Status.CONFIRMED.equals((Object)s.status()))) continue;
                return;
            }
            catch (Exception e) {
                lastException = e;
                try {
                    Thread.sleep(pollingIntervalInMillis);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        List<TransactionStatus> statuses = this.getTransactionsStatus(ids);
        List unconfirmed = statuses.stream().filter(s -> !Status.CONFIRMED.equals((Object)s.status())).collect(Collectors.toList());
        throw new IOException("Could not wait for " + unconfirmed.size() + " of " + ids.size() + " transactions in " + waitingInSeconds + " seconds: " + unconfirmed, lastException);
    }

    public void waitForTransactions(List<Id> ids) throws IOException, NodeException {
        this.waitForTransactions(ids, 60);
    }

    public void waitForTransactions(Id ... ids) throws IOException, NodeException {
        this.waitForTransactions(Arrays.asList(ids));
    }

    public int waitForHeight(int target, int waitingInSeconds) throws IOException, NodeException {
        int start;
        int prev = start = this.getHeight();
        int pollingIntervalInMillis = 100;
        if (waitingInSeconds < 1) {
            throw new IllegalStateException("waitForHeight: value must be positive. Current: " + waitingInSeconds);
        }
        for (long spentMillis = 0L; spentMillis < (long)waitingInSeconds * 1000L; spentMillis += (long)pollingIntervalInMillis) {
            int current = this.getHeight();
            if (current >= target) {
                return current;
            }
            if (current > prev) {
                prev = current;
                spentMillis = 0L;
            }
            try {
                Thread.sleep(pollingIntervalInMillis);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Could not wait for the height to rise from " + start + " to " + target + ": height " + prev + " did not grow for " + waitingInSeconds + " seconds");
    }

    public int waitForHeight(int expectedHeight) throws IOException, NodeException {
        return this.waitForHeight(expectedHeight, 180);
    }

    public int waitBlocks(int blocksCount, int waitingInSeconds) throws IOException, NodeException {
        if (waitingInSeconds < 1) {
            throw new IllegalStateException("waitBlocks: waiting value must be positive. Current: " + waitingInSeconds);
        }
        return this.waitForHeight(this.getHeight() + blocksCount, waitingInSeconds);
    }

    public int waitBlocks(int blocksCount) throws IOException, NodeException {
        return this.waitBlocks(blocksCount, 180);
    }

    protected RequestBuilder get(String path) {
        return RequestBuilder.get((URI)this.uri.resolve(path));
    }

    protected RequestBuilder post(String path) {
        return RequestBuilder.post((URI)this.uri.resolve(path));
    }

    protected HttpResponse exec(HttpUriRequest request) throws IOException, NodeException {
        HttpUriRequest rq = RequestBuilder.get((URI)Profile.STAGENET.uri().resolve("/addresses")).build();
        HttpResponse r = this.client.execute(request);
        if (r.getStatusLine().getStatusCode() != 200) {
            throw (NodeException)this.mapper.readValue(r.getEntity().getContent(), NodeException.class);
        }
        return r;
    }

    protected InputStream asInputStream(RequestBuilder request) throws IOException, NodeException {
        return this.exec(request.build()).getEntity().getContent();
    }

    protected <T> T asType(RequestBuilder request, TypeReference<T> reference) throws IOException, NodeException {
        return (T)this.mapper.readValue(this.asInputStream(request), reference);
    }

    protected JsonNode asJson(RequestBuilder request) throws IOException, NodeException {
        return JsonSerializer.JSON_MAPPER.readTree(this.asInputStream(request));
    }
}

