/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.wavesj.LeaseStatus;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class LeaseInfo {
    private final Id id;
    private final Id originTransactionId;
    private final Address sender;
    private final Recipient recipient;
    private final long amount;
    private final int height;
    private final LeaseStatus status;
    private final int cancelHeight;
    private final Id cancelTransactionId;

    @JsonCreator
    public LeaseInfo(@JsonProperty(value="id") Id id, @JsonProperty(value="originTransactionId") Id originTransactionId, @JsonProperty(value="sender") Address sender, @JsonProperty(value="recipient") Recipient recipient, @JsonProperty(value="amount") long amount, @JsonProperty(value="height") int height, @JsonProperty(value="status") LeaseStatus status, @JsonProperty(value="cancelHeight") int cancelHeight, @JsonProperty(value="cancelTransactionId") Id cancelTransactionId) {
        this.id = id;
        this.originTransactionId = originTransactionId;
        this.sender = sender;
        this.recipient = recipient;
        this.amount = amount;
        this.height = height;
        this.status = status;
        this.cancelHeight = cancelHeight;
        this.cancelTransactionId = cancelTransactionId;
    }

    public Id id() {
        return this.id;
    }

    public Id originTransactionId() {
        return this.originTransactionId;
    }

    public Address sender() {
        return this.sender;
    }

    public Recipient recipient() {
        return this.recipient;
    }

    public long amount() {
        return this.amount;
    }

    public int height() {
        return this.height;
    }

    public LeaseStatus status() {
        return this.status;
    }

    public OptionalInt cancelHeight() {
        return this.cancelHeight > 0 ? OptionalInt.of(this.cancelHeight) : OptionalInt.empty();
    }

    public Optional<Id> cancelTransactionId() {
        return Optional.ofNullable(this.cancelTransactionId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaseInfo that = (LeaseInfo)o;
        return Objects.equals(this.id, that.id) && this.status == that.status && this.height == that.height && this.amount == that.amount && Objects.equals(this.sender, that.sender) && Objects.equals(this.recipient, that.recipient) && Objects.equals(this.originTransactionId, that.originTransactionId) && this.cancelHeight == that.cancelHeight && Objects.equals(this.cancelTransactionId, that.cancelTransactionId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.originTransactionId, this.sender, this.recipient, this.amount, this.height, this.status, this.cancelHeight, this.cancelTransactionId});
    }

    public String toString() {
        return "LeaseInfo{id=" + this.id + ", originTransactionId=" + this.originTransactionId + ", sender=" + this.sender + ", recipient=" + this.recipient + ", amount=" + this.amount + ", height=" + this.height + ", status=" + (Object)((Object)this.status) + ", cancelHeight=" + this.cancelHeight + ", cancelTransactionId=" + this.cancelTransactionId + '}';
    }
}

