/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.common.Base58String;
import com.wavesplatform.wavesj.Common;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BlockHeaders {
    private final int version;
    private final long timestamp;
    private final Base58String reference;
    private long baseTarget;
    private Base58String generationSignature;
    private final Base58String transactionsRoot;
    private final Base58String id;
    private final List<Integer> features;
    private final long desiredReward;
    private final Address generator;
    private final Base58String signature;
    private final int size;
    private final int transactionsCount;
    private final int height;
    private final long totalFee;
    private final long reward;
    private final Base58String vrf;

    @JsonCreator
    public BlockHeaders(@JsonProperty(value="version") int version, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="reference") Base58String reference, @JsonProperty(value="transactionsRoot") Base58String transactionsRoot, @JsonProperty(value="id") Base58String id, @JsonProperty(value="features") List<Integer> features, @JsonProperty(value="desiredReward") long desiredReward, @JsonProperty(value="generator") Address generator, @JsonProperty(value="signature") Base58String signature, @JsonProperty(value="blocksize") int size, @JsonProperty(value="transactionCount") int transactionsCount, @JsonProperty(value="height") int height, @JsonProperty(value="totalFee") long totalFee, @JsonProperty(value="reward") long reward, @JsonProperty(value="VRF") Base58String vrf) {
        this.height = height;
        this.version = version;
        this.timestamp = timestamp;
        this.reference = Common.notNull(reference, "Reference");
        this.generator = Common.notNull(generator, "Generator");
        this.signature = Common.notNull(signature, "Signature");
        this.id = id == null ? this.signature : id;
        this.vrf = vrf == null ? Base58String.empty() : vrf;
        this.transactionsRoot = transactionsRoot == null ? Base58String.empty() : transactionsRoot;
        this.size = size;
        this.transactionsCount = transactionsCount;
        this.totalFee = totalFee;
        this.reward = reward;
        this.desiredReward = desiredReward;
        this.features = features == null ? new ArrayList() : features;
    }

    @JsonProperty(value="nxt-consensus")
    private void nxtConsensus(Map<String, Object> nxtConsensus) {
        this.baseTarget = ((Integer)nxtConsensus.get("base-target")).intValue();
        this.generationSignature = new Base58String((String)nxtConsensus.get("generation-signature"));
    }

    public int version() {
        return this.version;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Base58String reference() {
        return this.reference;
    }

    public long baseTarget() {
        return this.baseTarget;
    }

    public Base58String generationSignature() {
        return this.generationSignature;
    }

    public Base58String transactionsRoot() {
        return this.transactionsRoot;
    }

    public Base58String id() {
        return this.id;
    }

    public List<Integer> features() {
        return this.features;
    }

    public long desiredReward() {
        return this.desiredReward;
    }

    public Address generator() {
        return this.generator;
    }

    public Base58String signature() {
        return this.signature;
    }

    public int size() {
        return this.size;
    }

    public int transactionsCount() {
        return this.transactionsCount;
    }

    public int height() {
        return this.height;
    }

    public long totalFee() {
        return this.totalFee;
    }

    public long reward() {
        return this.reward;
    }

    public Base58String vrf() {
        return this.vrf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockHeaders that = (BlockHeaders)o;
        return this.version == that.version && this.timestamp == that.timestamp && this.baseTarget == that.baseTarget && this.desiredReward == that.desiredReward && this.size == that.size && this.transactionsCount == that.transactionsCount && this.height == that.height && this.totalFee == that.totalFee && this.reward == that.reward && Objects.equals(this.reference, that.reference) && Objects.equals(this.generationSignature, that.generationSignature) && Objects.equals(this.transactionsRoot, that.transactionsRoot) && Objects.equals(this.id, that.id) && Objects.equals(this.features, that.features) && Objects.equals(this.generator, that.generator) && Objects.equals(this.signature, that.signature) && Objects.equals(this.vrf, that.vrf);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.timestamp, this.reference, this.baseTarget, this.generationSignature, this.transactionsRoot, this.id, this.features, this.desiredReward, this.generator, this.signature, this.size, this.transactionsCount, this.height, this.totalFee, this.reward, this.vrf);
    }

    public String toString() {
        return "BlockHeader{id=" + this.id + ", height=" + this.height + ", timestamp=" + this.timestamp + ", generator=" + this.generator + ", version=" + this.version + ", reference=" + this.reference + ", baseTarget=" + this.baseTarget + ", generationSignature='" + this.generationSignature + '\'' + ", vrf=" + this.vrf + ", features=" + this.features + ", signature='" + this.signature + '\'' + ", desiredReward=" + this.desiredReward + ", reward=" + this.reward + ", totalFee=" + this.totalFee + ", transactionsCount=" + this.transactionsCount + ", transactionsRoot='" + this.transactionsRoot + '\'' + ", size=" + this.size + '}';
    }
}

