/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.common.Base58String;
import com.wavesplatform.wavesj.BlockHeaders;
import com.wavesplatform.wavesj.Common;
import com.wavesplatform.wavesj.info.TransactionWithStatus;
import java.util.List;
import java.util.Objects;

public class Block
extends BlockHeaders {
    private final List<TransactionWithStatus> transactions;
    private final long fee;

    @JsonCreator
    public Block(@JsonProperty(value="version") int version, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="reference") Base58String reference, @JsonProperty(value="transactionsRoot") Base58String transactionsRoot, @JsonProperty(value="id") Base58String id, @JsonProperty(value="features") List<Integer> features, @JsonProperty(value="desiredReward") long desiredReward, @JsonProperty(value="generator") Address generator, @JsonProperty(value="signature") Base58String signature, @JsonProperty(value="blocksize") int size, @JsonProperty(value="transactionCount") int transactionsCount, @JsonProperty(value="height") int height, @JsonProperty(value="totalFee") long totalFee, @JsonProperty(value="reward") long reward, @JsonProperty(value="VRF") Base58String vrf, @JsonProperty(value="fee") long fee, @JsonProperty(value="transactions") List<TransactionWithStatus> transactions) {
        super(version, timestamp, reference, transactionsRoot, id, features, desiredReward, generator, signature, size, transactionsCount, height, totalFee, reward, vrf);
        this.fee = fee;
        this.transactions = Common.notNull(transactions, "Transactions");
    }

    public long fee() {
        return this.fee;
    }

    public List<TransactionWithStatus> transactions() {
        return this.transactions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Block block = (Block)o;
        return this.fee == block.fee && Objects.equals(this.transactions, block.transactions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fee, this.transactions);
    }

    @Override
    public String toString() {
        return "Block{transactions=" + this.transactions + ", fee=" + this.fee + "} " + super.toString();
    }
}

