/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.wavesj;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.wavesj.Common;
import com.wavesplatform.wavesj.ScriptDetails;
import java.util.Objects;

public class AssetDetails {
    private final AssetId assetId;
    private final int issueHeight;
    private final long issueTimestamp;
    private final Address issuer;
    private final PublicKey issuerPublicKey;
    private final String name;
    private final String description;
    private final int decimals;
    private final boolean reissuable;
    private final long quantity;
    private final boolean scripted;
    private final long minSponsoredAssetFee;
    private final Id originTransactionId;
    private final ScriptDetails scriptDetails;

    @JsonCreator
    public AssetDetails(@JsonProperty(value="assetId") AssetId assetId, @JsonProperty(value="issueHeight") int issueHeight, @JsonProperty(value="issueTimestamp") long issueTimestamp, @JsonProperty(value="issuer") Address issuer, @JsonProperty(value="issuerPublicKey") PublicKey issuerPublicKey, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="decimals") int decimals, @JsonProperty(value="reissuable") boolean reissuable, @JsonProperty(value="quantity") long quantity, @JsonProperty(value="scripted") boolean scripted, @JsonProperty(value="minSponsoredAssetFee") long minSponsoredAssetFee, @JsonProperty(value="originTransactionId") Id originTransactionId, @JsonProperty(value="scriptDetails") ScriptDetails scriptDetails) {
        this.assetId = Common.notNull(assetId, "AssetId");
        this.issueHeight = issueHeight;
        this.issueTimestamp = issueTimestamp;
        this.issuer = Common.notNull(issuer, "Issuer");
        this.issuerPublicKey = Common.notNull(issuerPublicKey, "IssuerPublicKey");
        this.name = Common.notNull(name, "Name");
        this.description = Common.notNull(description, "Description");
        this.decimals = decimals;
        this.reissuable = reissuable;
        this.quantity = quantity;
        this.scripted = scripted;
        this.minSponsoredAssetFee = minSponsoredAssetFee;
        this.originTransactionId = Common.notNull(originTransactionId, "OriginTransactionId");
        this.scriptDetails = scriptDetails == null ? new ScriptDetails("", 0) : scriptDetails;
    }

    public AssetId assetId() {
        return this.assetId;
    }

    public int issueHeight() {
        return this.issueHeight;
    }

    public long issueTimestamp() {
        return this.issueTimestamp;
    }

    public Address issuer() {
        return this.issuer;
    }

    public PublicKey issuerPublicKey() {
        return this.issuerPublicKey;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public int decimals() {
        return this.decimals;
    }

    public boolean isReissuable() {
        return this.reissuable;
    }

    public long quantity() {
        return this.quantity;
    }

    public boolean isScripted() {
        return this.scripted;
    }

    public long minSponsoredAssetFee() {
        return this.minSponsoredAssetFee;
    }

    public Id originTransactionId() {
        return this.originTransactionId;
    }

    public ScriptDetails scriptDetails() {
        return this.scriptDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetDetails that = (AssetDetails)o;
        return this.issueHeight == that.issueHeight && this.issueTimestamp == that.issueTimestamp && this.decimals == that.decimals && this.reissuable == that.reissuable && this.quantity == that.quantity && this.scripted == that.scripted && this.minSponsoredAssetFee == that.minSponsoredAssetFee && Objects.equals(this.assetId, that.assetId) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.issuerPublicKey, that.issuerPublicKey) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.originTransactionId, that.originTransactionId) && Objects.equals(this.scriptDetails, that.scriptDetails);
    }

    public int hashCode() {
        return Objects.hash(this.assetId, this.issueHeight, this.issueTimestamp, this.issuer, this.issuerPublicKey, this.name, this.description, this.decimals, this.reissuable, this.quantity, this.scripted, this.minSponsoredAssetFee, this.originTransactionId, this.scriptDetails);
    }

    public String toString() {
        return "AssetDetails{assetId=" + this.assetId + ", issueHeight=" + this.issueHeight + ", issueTimestamp=" + this.issueTimestamp + ", issuer=" + this.issuer + ", issuerPublicKey=" + this.issuerPublicKey + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", decimals=" + this.decimals + ", reissuable=" + this.reissuable + ", quantity=" + this.quantity + ", scripted=" + this.scripted + ", minSponsoredAssetFee=" + this.minSponsoredAssetFee + ", originTransactionId=" + this.originTransactionId + ", scriptDetails=" + this.scriptDetails + '}';
    }
}

