/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.serializers.eth;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.DefaultFunctionEncoder;
import org.web3j.abi.TypeEncoder;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.DynamicStruct;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.NumericType;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Ufixed;
import org.web3j.abi.datatypes.Uint;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.utils.Numeric;

public class EthFunctionEncoder
extends DefaultFunctionEncoder {
    public static String encodeWavesFunctionInEthFmt(Function function) {
        List parameters = function.getInputParameters();
        String methodSignature = EthFunctionEncoder.buildMethodSignature((String)function.getName(), (List)parameters);
        String methodId = EthFunctionEncoder.buildMethodId((String)methodSignature);
        Type lastParam = (Type)parameters.get(parameters.size() - 1);
        if (((Type)((StaticStruct)((ArrayList)lastParam.getValue()).get(0)).getValue().get(1)).getValue().equals(BigInteger.ZERO)) {
            parameters.remove(lastParam);
            parameters.add(new DynamicArray(StaticStruct.class, Collections.emptyList()));
        }
        StringBuilder result = new StringBuilder(methodId);
        return EthFunctionEncoder.encodeParameters(parameters, result);
    }

    private static String encodeParameters(List<Type> parameters, StringBuilder result) {
        int dynamicDataOffset = EthFunctionEncoder.getLength(parameters) * 32;
        StringBuilder dynamicData = new StringBuilder();
        for (Type parameter : parameters) {
            String encodedValue = TypeEncoder.encode((Type)parameter);
            if (EthFunctionEncoder.isDynamic(parameter)) {
                String encodedDataOffset = EthFunctionEncoder.encodeNumeric((NumericType)new Uint(BigInteger.valueOf(dynamicDataOffset)));
                result.append(encodedDataOffset);
                dynamicData.append(encodedValue);
                dynamicDataOffset += encodedValue.length() >> 1;
                continue;
            }
            result.append(encodedValue);
        }
        result.append((CharSequence)dynamicData);
        return result.toString();
    }

    private static boolean isDynamic(Type parameter) {
        return parameter instanceof DynamicBytes || parameter instanceof Utf8String || parameter instanceof DynamicArray || parameter instanceof StaticArray && DynamicStruct.class.isAssignableFrom(((StaticArray)parameter).getComponentType());
    }

    private static String encodeNumeric(NumericType numericType) {
        byte[] rawValue = EthFunctionEncoder.toByteArray(numericType);
        byte paddingValue = EthFunctionEncoder.getPaddingValue(numericType);
        byte[] paddedRawValue = new byte[32];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, 32 - rawValue.length, rawValue.length);
        return Numeric.toHexStringNoPrefix((byte[])paddedRawValue);
    }

    private static byte[] toByteArray(NumericType numericType) {
        BigInteger value = numericType.getValue();
        if ((numericType instanceof Ufixed || numericType instanceof Uint) && value.bitLength() == 256) {
            byte[] byteArray = new byte[32];
            System.arraycopy(value.toByteArray(), 1, byteArray, 0, 32);
            return byteArray;
        }
        return value.toByteArray();
    }

    private static int getLength(List<Type> parameters) {
        int count = 0;
        for (Type type : parameters) {
            if (type instanceof StaticArray && StaticStruct.class.isAssignableFrom(((StaticArray)type).getComponentType())) {
                count += Utils.staticStructNestedPublicFieldsFlatList((Class)((StaticArray)type).getComponentType()).size() * ((StaticArray)type).getValue().size();
                continue;
            }
            if (type instanceof StaticArray && DynamicStruct.class.isAssignableFrom(((StaticArray)type).getComponentType())) {
                ++count;
                continue;
            }
            if (type instanceof StaticArray) {
                count += ((StaticArray)type).getValue().size();
                continue;
            }
            ++count;
        }
        return count;
    }

    private static byte getPaddingValue(NumericType numericType) {
        if (numericType.getValue().signum() == -1) {
            return -1;
        }
        return 0;
    }
}

