/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.serializers.binary;

import com.wavesplatform.crypto.Bytes;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.transactions.exchange.OrderType;
import com.wavesplatform.transactions.invocation.Arg;
import com.wavesplatform.transactions.invocation.BinaryArg;
import com.wavesplatform.transactions.invocation.BooleanArg;
import com.wavesplatform.transactions.invocation.Function;
import com.wavesplatform.transactions.invocation.IntegerArg;
import com.wavesplatform.transactions.invocation.ListArg;
import com.wavesplatform.transactions.invocation.StringArg;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class BytesWriter {
    private byte[] buf;

    public BytesWriter(int size) {
        this.buf = new byte[size];
    }

    public BytesWriter() {
        this(0);
    }

    public byte[] getBytes() {
        return this.buf;
    }

    public BytesWriter write(byte ... value) {
        this.buf = Bytes.concat((byte[][])new byte[][]{this.buf, value});
        return this;
    }

    public BytesWriter writeBoolean(boolean value) {
        return this.write((byte)(value ? 1 : 0));
    }

    public BytesWriter writeArrayWithLength(byte[] value) {
        return this.write(Bytes.fromShort((short)((short)value.length))).write(value);
    }

    public BytesWriter writeOptionArrayWithLength(byte[] value) {
        if (value != null && value.length > 0) {
            return this.writeBoolean(true).writeArrayWithLength(value);
        }
        return this.writeBoolean(false);
    }

    public BytesWriter writeShort(short value) {
        return this.write(Bytes.fromShort((short)value));
    }

    public BytesWriter writeInt(int value) {
        return this.write(Bytes.fromInt((int)value));
    }

    public BytesWriter writeLong(long value) {
        return this.write(Bytes.fromLong((long)value));
    }

    public BytesWriter writeOrderType(OrderType type) {
        if (type == OrderType.BUY) {
            this.write(0);
        } else if (type == OrderType.SELL) {
            this.write(1);
        } else {
            throw new IllegalArgumentException("Unknown order type " + (Object)((Object)type) + " (not BUY or SELL)");
        }
        return this;
    }

    public BytesWriter writePublicKey(PublicKey publicKey) {
        return this.write(publicKey.bytes());
    }

    public BytesWriter writeRecipient(Recipient recipient) {
        return this.write(recipient.bytes());
    }

    public BytesWriter writeAssetId(AssetId assetId) {
        return this.write(assetId.bytes());
    }

    public BytesWriter writeAssetIdOrWaves(AssetId assetIdOrWaves) {
        return assetIdOrWaves.isWaves() ? this.write(0) : this.write(1).write(assetIdOrWaves.bytes());
    }

    public BytesWriter writeTxId(Id id) {
        return this.write(id.bytes());
    }

    public BytesWriter writeFunction(Function function) {
        if (function.isDefault()) {
            return this.write(0);
        }
        this.write(1, 9, 1).writeInt(function.name().length()).write(function.name().getBytes(StandardCharsets.UTF_8)).writeArguments(function.args());
        return this;
    }

    public BytesWriter writeArguments(List<Arg> args) {
        this.writeInt(args.size());
        args.forEach(arg -> {
            if (arg instanceof IntegerArg) {
                this.write(0).writeLong(((IntegerArg)arg).value());
            } else if (arg instanceof BinaryArg) {
                BinaryArg binArg = (BinaryArg)arg;
                int intLength = binArg.value().bytes().length;
                this.write(1).writeInt(intLength).write(binArg.value().bytes());
            } else if (arg instanceof StringArg) {
                StringArg strArg = (StringArg)arg;
                byte[] valueBytes = strArg.value().getBytes(StandardCharsets.UTF_8);
                this.write(2).writeInt(valueBytes.length).write(valueBytes);
            } else if (arg instanceof BooleanArg) {
                this.write((byte)(((BooleanArg)arg).value() ? 6 : 7));
            } else if (arg instanceof ListArg) {
                this.write(11).writeArguments(((ListArg)arg).value());
            } else {
                throw new IllegalArgumentException("Unknown arg type " + (Object)((Object)arg.type()));
            }
        });
        return this;
    }

    public BytesWriter writeSignature(List<Proof> proofs) {
        if (proofs.size() != 1) {
            throw new IllegalArgumentException("1 signature expected but " + proofs.size() + " proofs found");
        }
        return this.write(proofs.get(0).bytes());
    }

    public BytesWriter writeProofs(List<Proof> proofs) {
        this.write(1).writeShort((short)proofs.size());
        proofs.forEach(proof -> this.writeArrayWithLength(proof.bytes()));
        return this;
    }
}

