/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.serializers.binary;

import com.wavesplatform.crypto.Bytes;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Alias;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.transactions.exchange.OrderType;
import com.wavesplatform.transactions.invocation.Arg;
import com.wavesplatform.transactions.invocation.BinaryArg;
import com.wavesplatform.transactions.invocation.BooleanArg;
import com.wavesplatform.transactions.invocation.Function;
import com.wavesplatform.transactions.invocation.IntegerArg;
import com.wavesplatform.transactions.invocation.ListArg;
import com.wavesplatform.transactions.invocation.StringArg;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BytesReader {
    private final byte[] bytes;
    private final int length;
    private int index;

    public BytesReader(byte[] bytes) {
        this.bytes = bytes;
        this.length = this.bytes.length;
        this.index = 0;
    }

    public boolean hasNext() {
        return this.index < this.length;
    }

    public boolean skip(int count) {
        this.index += count;
        return this.hasNext();
    }

    public int rest() {
        return this.bytes.length - this.index;
    }

    public byte readByte() {
        return this.bytes[this.index++];
    }

    public byte[] readBytes(int count) {
        byte[] result = Arrays.copyOfRange(this.bytes, this.index, this.index + count);
        this.index += count;
        return result;
    }

    public boolean readBoolean() {
        byte byt = this.readByte();
        if (byt == 0) {
            return false;
        }
        if (byt == 1) {
            return true;
        }
        throw new IllegalArgumentException("Can't read byte " + byt + " as boolean. Expected 1 or 0");
    }

    public short readShort() {
        return Bytes.toShort((byte[])this.readBytes(2));
    }

    public int readInt() {
        return Bytes.toInt((byte[])this.readBytes(4));
    }

    public long readLong() {
        return Bytes.toLong((byte[])this.readBytes(8));
    }

    public OrderType readOrderType() {
        return this.readBoolean() ? OrderType.SELL : OrderType.BUY;
    }

    public byte[] readArrayWithLength() {
        short arrayLength = this.readShort();
        return this.readBytes(arrayLength);
    }

    public byte[] readOptionArrayWithLength() {
        return this.readBoolean() ? this.readArrayWithLength() : Bytes.empty();
    }

    public PublicKey readPublicKey() {
        return PublicKey.as(this.readBytes(32));
    }

    public Recipient readRecipient() {
        byte recipientType = this.readByte();
        if (recipientType == 1) {
            return Address.as(Bytes.concat((byte[][])new byte[][]{Bytes.of((byte[])new byte[]{recipientType}), this.readBytes(25)}));
        }
        if (recipientType == 2) {
            return Alias.as(this.readByte(), new String(this.readArrayWithLength()));
        }
        throw new IllegalArgumentException("Unknown recipient type");
    }

    public AssetId readAssetId() {
        return AssetId.as(this.readBytes(32));
    }

    public AssetId readAssetIdOrWaves() {
        boolean isAsset = this.readBoolean();
        return isAsset ? this.readAssetId() : AssetId.WAVES;
    }

    public Id readTxId() {
        return Id.as(this.readBytes(32));
    }

    public Function readFunctionCall() {
        if (this.readBoolean()) {
            if (this.readByte() != 9) {
                throw new IllegalArgumentException("FunctionCall Id must be equal 9");
            }
            if (this.readByte() != 1) {
                throw new IllegalArgumentException("Function type Id must be equal 1");
            }
            String name = new String(this.readBytes(this.readInt()), StandardCharsets.UTF_8);
            List<Arg> args = this.readArguments();
            return Function.as(name, args);
        }
        return Function.asDefault();
    }

    public List<Arg> readArguments() {
        int argsCount = this.readInt();
        ArrayList<Arg> args = new ArrayList<Arg>();
        for (int i = 0; i < argsCount; ++i) {
            byte argType = this.readByte();
            if (argType == 0) {
                args.add(IntegerArg.as(this.readLong()));
                continue;
            }
            if (argType == 1) {
                args.add(BinaryArg.as(this.readBytes(this.readInt())));
                continue;
            }
            if (argType == 2) {
                args.add(StringArg.as(new String(this.readBytes(this.readInt()), StandardCharsets.UTF_8)));
                continue;
            }
            if (argType == 6) {
                args.add(BooleanArg.as(true));
                continue;
            }
            if (argType == 7) {
                args.add(BooleanArg.as(false));
                continue;
            }
            if (argType == 11) {
                args.add(ListArg.as(this.readArguments()));
                continue;
            }
            throw new IllegalArgumentException("Unknown arg type " + argType);
        }
        return args;
    }

    public List<Proof> readSignature() {
        return Proof.list(Proof.as(this.readBytes(64)));
    }

    public List<Proof> readProofs() {
        byte version = this.readByte();
        if (version != 1) {
            throw new IllegalArgumentException("Wrong proofs version " + version + " but " + 1 + " expected");
        }
        List<Proof> result = Proof.emptyList();
        short proofsCount = this.readShort();
        for (short i = 0; i < proofsCount; i = (short)(i + 1)) {
            result.add(Proof.as(this.readArrayWithLength()));
        }
        return result;
    }
}

