/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.serializers.binary;

import com.google.protobuf.InvalidProtocolBufferException;
import com.wavesplatform.protobuf.order.OrderOuterClass;
import com.wavesplatform.protobuf.transaction.TransactionOuterClass;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.TransactionOrOrder;
import com.wavesplatform.transactions.exchange.Order;
import com.wavesplatform.transactions.serializers.ProtobufConverter;
import com.wavesplatform.transactions.serializers.Scheme;
import com.wavesplatform.transactions.serializers.binary.LegacyBinarySerializer;
import java.io.IOException;

public abstract class BinarySerializer {
    public static Order orderFromBytes(byte[] bytes) throws IOException {
        OrderOuterClass.Order pbOrder;
        try {
            pbOrder = OrderOuterClass.Order.parseFrom((byte[])bytes);
            if (!pbOrder.isInitialized()) {
                throw new InvalidProtocolBufferException("Parsed bytes are not an Order");
            }
        }
        catch (InvalidProtocolBufferException e) {
            try {
                return LegacyBinarySerializer.orderFromBytes(bytes, true);
            }
            catch (IllegalArgumentException ioe) {
                return LegacyBinarySerializer.orderFromBytes(bytes, false);
            }
        }
        return ProtobufConverter.fromProtobuf(pbOrder);
    }

    public static Transaction transactionFromBytes(byte[] bytes) throws IOException {
        TransactionOuterClass.SignedTransaction signed;
        try {
            signed = TransactionOuterClass.SignedTransaction.parseFrom((byte[])bytes);
            if (!signed.isInitialized()) {
                throw new InvalidProtocolBufferException("Parsed bytes are not a Transaction");
            }
        }
        catch (InvalidProtocolBufferException e) {
            return LegacyBinarySerializer.transactionFromBytes(bytes);
        }
        return ProtobufConverter.fromProtobuf(signed);
    }

    public static byte[] bodyBytes(TransactionOrOrder txOrOrder) {
        if (Scheme.of(txOrOrder) == Scheme.PROTOBUF) {
            if (txOrOrder instanceof Order) {
                return ProtobufConverter.toUnsignedProtobuf((Order)txOrOrder).toByteArray();
            }
            return ProtobufConverter.toUnsignedProtobuf((Transaction)txOrOrder).toByteArray();
        }
        return LegacyBinarySerializer.bodyBytes(txOrOrder);
    }

    public static byte[] toBytes(TransactionOrOrder txOrOrder) {
        if (Scheme.of(txOrOrder) == Scheme.PROTOBUF) {
            if (txOrOrder instanceof Order) {
                return ProtobufConverter.toProtobuf((Order)txOrOrder).toByteArray();
            }
            return ProtobufConverter.toProtobuf((Transaction)txOrOrder).toByteArray();
        }
        return LegacyBinarySerializer.toBytes(txOrOrder);
    }
}

