/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.serializers;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.TransactionOrOrder;
import com.wavesplatform.transactions.exchange.Order;

public enum Scheme {
    WITH_SIGNATURE,
    WITH_PROOFS,
    PROTOBUF;


    public static Scheme ofOrder(int version) {
        if (version == 1) {
            return WITH_SIGNATURE;
        }
        if (version == 2 || version == 3) {
            return WITH_PROOFS;
        }
        if (version >= 4) {
            return PROTOBUF;
        }
        throw new IllegalArgumentException("Unsupported order version " + version);
    }

    public static Scheme of(int txType, int txVersion) {
        if ((txType == 1 || txType == 2) && txVersion == 1) {
            return WITH_SIGNATURE;
        }
        if (txType >= 3 && txType <= 10) {
            if (txVersion == 1) {
                return WITH_SIGNATURE;
            }
            if (txVersion == 2) {
                return WITH_PROOFS;
            }
            if (txVersion >= 3) {
                return PROTOBUF;
            }
        }
        if (txType >= 11 && txType <= 16) {
            if (txVersion == 1) {
                return WITH_PROOFS;
            }
            if (txVersion >= 2) {
                return PROTOBUF;
            }
        }
        if (txType == 17 && txVersion >= 1) {
            return PROTOBUF;
        }
        if (txType == 18) {
            return PROTOBUF;
        }
        throw new IllegalArgumentException("Unsupported transaction type " + txType + " with version " + txVersion);
    }

    public static Scheme of(TransactionOrOrder txOrOrder) {
        if (txOrOrder instanceof Order) {
            return Scheme.ofOrder(txOrOrder.version());
        }
        if (txOrOrder instanceof Transaction) {
            return Scheme.of(((Transaction)txOrOrder).type(), txOrOrder.version());
        }
        throw new IllegalArgumentException("Can't recognize transaction or order of " + txOrOrder.getClass().getCanonicalName());
    }
}

