/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.serializers;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.wavesplatform.crypto.base.Base58;
import com.wavesplatform.events.protobuf.Events;
import com.wavesplatform.protobuf.AmountOuterClass;
import com.wavesplatform.protobuf.order.OrderOuterClass;
import com.wavesplatform.protobuf.transaction.InvokeScriptResultOuterClass;
import com.wavesplatform.protobuf.transaction.RecipientOuterClass;
import com.wavesplatform.protobuf.transaction.TransactionOuterClass;
import com.wavesplatform.transactions.BurnTransaction;
import com.wavesplatform.transactions.CreateAliasTransaction;
import com.wavesplatform.transactions.DataTransaction;
import com.wavesplatform.transactions.EthereumTransaction;
import com.wavesplatform.transactions.ExchangeTransaction;
import com.wavesplatform.transactions.GenesisTransaction;
import com.wavesplatform.transactions.InvokeScriptTransaction;
import com.wavesplatform.transactions.IssueTransaction;
import com.wavesplatform.transactions.LeaseCancelTransaction;
import com.wavesplatform.transactions.LeaseTransaction;
import com.wavesplatform.transactions.MassTransferTransaction;
import com.wavesplatform.transactions.PaymentTransaction;
import com.wavesplatform.transactions.ReissueTransaction;
import com.wavesplatform.transactions.SetAssetScriptTransaction;
import com.wavesplatform.transactions.SetScriptTransaction;
import com.wavesplatform.transactions.SponsorFeeTransaction;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.TransferTransaction;
import com.wavesplatform.transactions.UpdateAssetInfoTransaction;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Alias;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base58String;
import com.wavesplatform.transactions.common.Base64String;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.transactions.data.BinaryEntry;
import com.wavesplatform.transactions.data.BooleanEntry;
import com.wavesplatform.transactions.data.DeleteEntry;
import com.wavesplatform.transactions.data.IntegerEntry;
import com.wavesplatform.transactions.data.StringEntry;
import com.wavesplatform.transactions.exchange.Order;
import com.wavesplatform.transactions.exchange.OrderType;
import com.wavesplatform.transactions.invocation.Arg;
import com.wavesplatform.transactions.invocation.BinaryArg;
import com.wavesplatform.transactions.invocation.BooleanArg;
import com.wavesplatform.transactions.invocation.Function;
import com.wavesplatform.transactions.invocation.IntegerArg;
import com.wavesplatform.transactions.invocation.ListArg;
import com.wavesplatform.transactions.invocation.StringArg;
import com.wavesplatform.transactions.mass.Transfer;
import com.wavesplatform.transactions.serializers.binary.BytesReader;
import com.wavesplatform.transactions.serializers.binary.BytesWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.crypto.SignedRawTransaction;
import org.web3j.crypto.TransactionDecoder;
import org.web3j.utils.Numeric;

public abstract class ProtobufConverter {
    public static Order fromProtobuf(OrderOuterClass.Order pbOrder) throws IOException {
        OrderType type;
        if (pbOrder.getOrderSide() == OrderOuterClass.Order.Side.BUY) {
            type = OrderType.BUY;
        } else if (pbOrder.getOrderSide() == OrderOuterClass.Order.Side.SELL) {
            type = OrderType.SELL;
        } else {
            throw new IOException("Unknown order type \"" + pbOrder.getOrderSide() + "\"");
        }
        Order order = (Order)((Order.OrderBuilder)((Order.OrderBuilder)((Order.OrderBuilder)((Order.OrderBuilder)((Order.OrderBuilder)Order.builder(type, Amount.of(pbOrder.getAmount(), AssetId.as(pbOrder.getAssetPair().getAmountAssetId().toByteArray())), Amount.of(pbOrder.getPrice(), AssetId.as(pbOrder.getAssetPair().getPriceAssetId().toByteArray())), PublicKey.as(pbOrder.getMatcherPublicKey().toByteArray())).version(pbOrder.getVersion())).chainId((byte)pbOrder.getChainId())).sender(PublicKey.as(pbOrder.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbOrder.getMatcherFee()))).timestamp(pbOrder.getTimestamp())).expiration(pbOrder.getExpiration()).getUnsigned();
        pbOrder.getProofsList().forEach(p -> order.proofs().add(Proof.as(p.toByteArray())));
        return order;
    }

    public static Transaction fromProtobuf(TransactionOuterClass.SignedTransaction pbSignedTx) throws IOException {
        Transaction tx;
        if (!pbSignedTx.getEthereumTransaction().isEmpty()) {
            throw new IllegalArgumentException("Ethereum transaction not supported from this method. Use ethTransferTxFromProtobuf or ethInvokeScriptTxFromProtobuf instead");
        }
        if (!pbSignedTx.hasWavesTransaction()) {
            throw new InvalidProtocolBufferException("Waves transaction is missing");
        }
        TransactionOuterClass.Transaction pbTx = pbSignedTx.getWavesTransaction();
        if (pbTx.hasGenesis()) {
            TransactionOuterClass.GenesisTransactionData genesis = pbTx.getGenesis();
            tx = new GenesisTransaction(Address.as(genesis.getRecipientAddress().toByteArray()), genesis.getAmount(), pbTx.getTimestamp(), pbSignedTx.getProofsCount() > 0 ? Proof.as(pbSignedTx.getProofs(0).toByteArray()) : Proof.EMPTY);
        } else if (pbTx.hasPayment()) {
            TransactionOuterClass.PaymentTransactionData payment = pbTx.getPayment();
            tx = new PaymentTransaction(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()), Address.as(payment.getRecipientAddress().toByteArray()), payment.getAmount(), ProtobufConverter.pbAmountToAmount(pbTx.getFee()), pbTx.getTimestamp(), Proof.EMPTY);
        } else if (pbTx.hasIssue()) {
            TransactionOuterClass.IssueTransactionData issue = pbTx.getIssue();
            tx = new IssueTransaction(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()), issue.getNameBytes().toByteArray(), issue.getDescriptionBytes().toByteArray(), issue.getAmount(), issue.getDecimals(), issue.getReissuable(), new Base64String(issue.getScript().toByteArray()), (byte)pbTx.getChainId(), ProtobufConverter.pbAmountToAmount(pbTx.getFee()), pbTx.getTimestamp(), pbTx.getVersion(), Proof.emptyList());
        } else if (pbTx.hasTransfer()) {
            TransactionOuterClass.TransferTransactionData transfer = pbTx.getTransfer();
            AmountOuterClass.Amount amount = transfer.getAmount();
            tx = (Transaction)((TransferTransaction.TransferTransactionBuilder)((TransferTransaction.TransferTransactionBuilder)((TransferTransaction.TransferTransactionBuilder)((TransferTransaction.TransferTransactionBuilder)((TransferTransaction.TransferTransactionBuilder)TransferTransaction.builder(ProtobufConverter.recipientFromProto(transfer.getRecipient(), (byte)pbTx.getChainId()), Amount.of(amount.getAmount(), AssetId.as(amount.getAssetId().toByteArray()))).attachment(new Base58String(transfer.getAttachment().toByteArray())).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasReissue()) {
            TransactionOuterClass.ReissueTransactionData reissue = pbTx.getReissue();
            tx = (Transaction)((ReissueTransaction.ReissueTransactionBuilder)((ReissueTransaction.ReissueTransactionBuilder)((ReissueTransaction.ReissueTransactionBuilder)((ReissueTransaction.ReissueTransactionBuilder)((ReissueTransaction.ReissueTransactionBuilder)ReissueTransaction.builder(Amount.of(reissue.getAssetAmount().getAmount(), AssetId.as(reissue.getAssetAmount().getAssetId().toByteArray()))).reissuable(reissue.getReissuable()).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasBurn()) {
            TransactionOuterClass.BurnTransactionData burn = pbTx.getBurn();
            tx = (Transaction)((BurnTransaction.BurnTransactionBuilder)((BurnTransaction.BurnTransactionBuilder)((BurnTransaction.BurnTransactionBuilder)((BurnTransaction.BurnTransactionBuilder)((BurnTransaction.BurnTransactionBuilder)BurnTransaction.builder(Amount.of(burn.getAssetAmount().getAmount(), AssetId.as(burn.getAssetAmount().getAssetId().toByteArray()))).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasExchange()) {
            TransactionOuterClass.ExchangeTransactionData exchange = pbTx.getExchange();
            tx = (Transaction)((ExchangeTransaction.ExchangeTransactionBuilder)((ExchangeTransaction.ExchangeTransactionBuilder)((ExchangeTransaction.ExchangeTransactionBuilder)((ExchangeTransaction.ExchangeTransactionBuilder)((ExchangeTransaction.ExchangeTransactionBuilder)ExchangeTransaction.builder(ProtobufConverter.fromProtobuf(exchange.getOrders(0)), ProtobufConverter.fromProtobuf(exchange.getOrders(1)), exchange.getAmount(), exchange.getPrice(), exchange.getBuyMatcherFee(), exchange.getSellMatcherFee()).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasLease()) {
            TransactionOuterClass.LeaseTransactionData lease = pbTx.getLease();
            tx = (Transaction)((LeaseTransaction.LeaseTransactionBuilder)((LeaseTransaction.LeaseTransactionBuilder)((LeaseTransaction.LeaseTransactionBuilder)((LeaseTransaction.LeaseTransactionBuilder)((LeaseTransaction.LeaseTransactionBuilder)LeaseTransaction.builder(ProtobufConverter.recipientFromProto(lease.getRecipient(), (byte)pbTx.getChainId()), lease.getAmount()).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasLeaseCancel()) {
            TransactionOuterClass.LeaseCancelTransactionData leaseCancel = pbTx.getLeaseCancel();
            tx = (Transaction)((LeaseCancelTransaction.LeaseCancelTransactionBuilder)((LeaseCancelTransaction.LeaseCancelTransactionBuilder)((LeaseCancelTransaction.LeaseCancelTransactionBuilder)((LeaseCancelTransaction.LeaseCancelTransactionBuilder)((LeaseCancelTransaction.LeaseCancelTransactionBuilder)LeaseCancelTransaction.builder(Id.as(leaseCancel.getLeaseId().toByteArray())).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasCreateAlias()) {
            TransactionOuterClass.CreateAliasTransactionData alias = pbTx.getCreateAlias();
            tx = (Transaction)((CreateAliasTransaction.CreateAliasTransactionBuilder)((CreateAliasTransaction.CreateAliasTransactionBuilder)((CreateAliasTransaction.CreateAliasTransactionBuilder)((CreateAliasTransaction.CreateAliasTransactionBuilder)((CreateAliasTransaction.CreateAliasTransactionBuilder)CreateAliasTransaction.builder(new String(alias.getAliasBytes().toByteArray(), StandardCharsets.UTF_8)).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasMassTransfer()) {
            TransactionOuterClass.MassTransferTransactionData massTransfer = pbTx.getMassTransfer();
            List<Transfer> transfers = massTransfer.getTransfersList().stream().map(t -> Transfer.to(ProtobufConverter.recipientFromProto(t.getRecipient(), (byte)pbTx.getChainId()), t.getAmount())).collect(Collectors.toList());
            tx = (Transaction)((MassTransferTransaction.MassTransferTransactionBuilder)((MassTransferTransaction.MassTransferTransactionBuilder)((MassTransferTransaction.MassTransferTransactionBuilder)((MassTransferTransaction.MassTransferTransactionBuilder)((MassTransferTransaction.MassTransferTransactionBuilder)MassTransferTransaction.builder(transfers).assetId(AssetId.as(massTransfer.getAssetId().toByteArray())).attachment(new Base58String(massTransfer.getAttachment().toByteArray())).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasDataTransaction()) {
            TransactionOuterClass.DataTransactionData data = pbTx.getDataTransaction();
            tx = (Transaction)((DataTransaction.DataTransactionBuilder)((DataTransaction.DataTransactionBuilder)((DataTransaction.DataTransactionBuilder)((DataTransaction.DataTransactionBuilder)((DataTransaction.DataTransactionBuilder)DataTransaction.builder(data.getDataList().stream().map(e -> {
                if (e.getValueCase() == TransactionOuterClass.DataTransactionData.DataEntry.ValueCase.INT_VALUE) {
                    return new IntegerEntry(e.getKey(), e.getIntValue());
                }
                if (e.getValueCase() == TransactionOuterClass.DataTransactionData.DataEntry.ValueCase.BOOL_VALUE) {
                    return new BooleanEntry(e.getKey(), e.getBoolValue());
                }
                if (e.getValueCase() == TransactionOuterClass.DataTransactionData.DataEntry.ValueCase.BINARY_VALUE) {
                    return new BinaryEntry(e.getKey(), e.getBinaryValue().toByteArray());
                }
                if (e.getValueCase() == TransactionOuterClass.DataTransactionData.DataEntry.ValueCase.STRING_VALUE) {
                    return new StringEntry(e.getKey(), e.getStringValue());
                }
                if (e.getValueCase() == TransactionOuterClass.DataTransactionData.DataEntry.ValueCase.VALUE_NOT_SET) {
                    return new DeleteEntry(e.getKey());
                }
                throw new IllegalArgumentException("Unknown value case " + e.getValueCase().getNumber());
            }).collect(Collectors.toList())).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasSetScript()) {
            TransactionOuterClass.SetScriptTransactionData setScript = pbTx.getSetScript();
            tx = (Transaction)((SetScriptTransaction.SetScriptTransactionBuilder)((SetScriptTransaction.SetScriptTransactionBuilder)((SetScriptTransaction.SetScriptTransactionBuilder)((SetScriptTransaction.SetScriptTransactionBuilder)((SetScriptTransaction.SetScriptTransactionBuilder)SetScriptTransaction.builder(new Base64String(setScript.getScript().toByteArray())).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasSponsorFee()) {
            TransactionOuterClass.SponsorFeeTransactionData sponsor = pbTx.getSponsorFee();
            tx = (Transaction)((SponsorFeeTransaction.SponsorFeeTransactionBuilder)((SponsorFeeTransaction.SponsorFeeTransactionBuilder)((SponsorFeeTransaction.SponsorFeeTransactionBuilder)((SponsorFeeTransaction.SponsorFeeTransactionBuilder)((SponsorFeeTransaction.SponsorFeeTransactionBuilder)SponsorFeeTransaction.builder(AssetId.as(sponsor.getMinFee().getAssetId().toByteArray()), sponsor.getMinFee().getAmount()).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasSetAssetScript()) {
            TransactionOuterClass.SetAssetScriptTransactionData setAssetScript = pbTx.getSetAssetScript();
            tx = (Transaction)((SetAssetScriptTransaction.SetAssetScriptTransactionBuilder)((SetAssetScriptTransaction.SetAssetScriptTransactionBuilder)((SetAssetScriptTransaction.SetAssetScriptTransactionBuilder)((SetAssetScriptTransaction.SetAssetScriptTransactionBuilder)((SetAssetScriptTransaction.SetAssetScriptTransactionBuilder)SetAssetScriptTransaction.builder(AssetId.as(setAssetScript.getAssetId().toByteArray()), new Base64String(setAssetScript.getScript().toByteArray())).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasInvokeScript()) {
            TransactionOuterClass.InvokeScriptTransactionData invoke = pbTx.getInvokeScript();
            Function functionCall = new BytesReader(invoke.getFunctionCall().toByteArray()).readFunctionCall();
            tx = (Transaction)((InvokeScriptTransaction.InvokeScriptTransactionBuilder)((InvokeScriptTransaction.InvokeScriptTransactionBuilder)((InvokeScriptTransaction.InvokeScriptTransactionBuilder)((InvokeScriptTransaction.InvokeScriptTransactionBuilder)((InvokeScriptTransaction.InvokeScriptTransactionBuilder)InvokeScriptTransaction.builder(ProtobufConverter.recipientFromProto(invoke.getDApp(), (byte)pbTx.getChainId()), functionCall).payments(invoke.getPaymentsList().stream().map(p -> Amount.of(p.getAmount(), AssetId.as(p.getAssetId().toByteArray()))).collect(Collectors.toList())).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else if (pbTx.hasUpdateAssetInfo()) {
            TransactionOuterClass.UpdateAssetInfoTransactionData update = pbTx.getUpdateAssetInfo();
            tx = (Transaction)((UpdateAssetInfoTransaction.UpdateAssetInfoTransactionBuilder)((UpdateAssetInfoTransaction.UpdateAssetInfoTransactionBuilder)((UpdateAssetInfoTransaction.UpdateAssetInfoTransactionBuilder)((UpdateAssetInfoTransaction.UpdateAssetInfoTransactionBuilder)((UpdateAssetInfoTransaction.UpdateAssetInfoTransactionBuilder)UpdateAssetInfoTransaction.builder(AssetId.as(update.getAssetId().toByteArray()), update.getName(), update.getDescription()).version(pbTx.getVersion())).chainId((byte)pbTx.getChainId())).sender(PublicKey.as(pbTx.getSenderPublicKey().toByteArray()))).fee(ProtobufConverter.pbAmountToAmount(pbTx.getFee()))).timestamp(pbTx.getTimestamp())).getUnsigned();
        } else {
            throw new InvalidProtocolBufferException("Can't recognize transaction type");
        }
        pbSignedTx.getProofsList().forEach(p -> tx.proofs().add(Proof.as(p.toByteArray())));
        return tx;
    }

    public static List<Arg> fromPbArgument(List<InvokeScriptResultOuterClass.InvokeScriptResult.Call.Argument> pbArgs) {
        ArrayList<Arg> args = new ArrayList<Arg>();
        for (InvokeScriptResultOuterClass.InvokeScriptResult.Call.Argument arg : pbArgs) {
            switch (arg.getValueCase()) {
                case INTEGER_VALUE: {
                    args.add(IntegerArg.as(arg.getIntegerValue()));
                    break;
                }
                case BINARY_VALUE: {
                    args.add(BinaryArg.as(arg.getBinaryValue().toByteArray()));
                    break;
                }
                case STRING_VALUE: {
                    args.add(StringArg.as(arg.getStringValue()));
                    break;
                }
                case BOOLEAN_VALUE: {
                    args.add(BooleanArg.as(arg.getBooleanValue()));
                    break;
                }
                case LIST: {
                    args.add(ListArg.as(ProtobufConverter.fromPbArgument(arg.getList().getItemsList())));
                }
            }
        }
        return args;
    }

    public static EthereumTransaction ethTransferTxFromProtobuf(TransactionOuterClass.SignedTransaction pbSignedTx) {
        if (!pbSignedTx.getEthereumTransaction().isEmpty()) {
            SignedRawTransaction srt = (SignedRawTransaction)TransactionDecoder.decode((String)Numeric.toHexString((byte[])pbSignedTx.getEthereumTransaction().toByteArray()));
            String data = Numeric.cleanHexPrefix((String)srt.getTransaction().getData());
            if (data.isEmpty() && !srt.getTransaction().getValue().equals(BigInteger.ZERO)) {
                return EthereumTransaction.transfer(Address.fromPart(srt.getChainId().byteValue(), Numeric.hexStringToByteArray((String)srt.getTo())), Amount.of(srt.getValue().divide(EthereumTransaction.AMOUNT_MULTIPLIER).longValueExact()), srt.getGasPrice(), srt.getChainId().byteValue(), srt.getGasLimit().longValueExact(), srt.getNonce().longValueExact(), srt.getSignatureData());
            }
            if (data.startsWith("0xa9059cbb") && srt.getTransaction().getValue().equals(BigInteger.ZERO)) {
                return EthereumTransaction.transfer(Address.fromPart(srt.getChainId().byteValue(), Numeric.hexStringToByteArray((String)new org.web3j.abi.datatypes.Address(data.substring(8, 71)).toString())), Amount.of(Numeric.toBigInt((String)data.substring(72)).divide(EthereumTransaction.AMOUNT_MULTIPLIER).longValueExact(), AssetId.as(Numeric.hexStringToByteArray((String)srt.getTo()))), srt.getGasPrice(), srt.getChainId().byteValue(), srt.getGasLimit().longValueExact(), srt.getNonce().longValueExact(), srt.getSignatureData());
            }
        }
        throw new IllegalArgumentException("Transfer ethereum transaction is missing");
    }

    public static EthereumTransaction ethInvokeScriptTxFromProtobuf(TransactionOuterClass.SignedTransaction pbSignedTx, Events.TransactionMetadata pbTxMetadata) {
        if (!pbSignedTx.getEthereumTransaction().isEmpty()) {
            SignedRawTransaction srt = (SignedRawTransaction)TransactionDecoder.decode((String)Numeric.toHexString((byte[])pbSignedTx.getEthereumTransaction().toByteArray()));
            String data = Numeric.cleanHexPrefix((String)srt.getTransaction().getData());
            if (data.isEmpty() && !srt.getTransaction().getValue().equals(BigInteger.ZERO) || data.startsWith("0xa9059cbb") && srt.getTransaction().getValue().equals(BigInteger.ZERO)) {
                throw new IllegalArgumentException("Transfer ethereum transaction not supported from this method");
            }
            Events.TransactionMetadata.InvokeScriptMetadata invoke = pbTxMetadata.getEthereum().getInvoke();
            List<Amount> payments = invoke.getPaymentsList().stream().map(p -> Amount.of(p.getAmount(), AssetId.as(p.getAssetId().toByteArray()))).collect(Collectors.toList());
            return EthereumTransaction.invocation(Address.as(Base58.encode((byte[])invoke.getDAppAddress().toByteArray())), Function.as(invoke.getFunctionName(), ProtobufConverter.fromPbArgument(invoke.getArgumentsList())), payments, srt.getGasPrice(), srt.getChainId().byteValue(), srt.getGasLimit().longValueExact(), srt.getNonce().longValueExact(), srt.getSignatureData());
        }
        throw new IllegalArgumentException("Invoke script ethereum transaction is missing");
    }

    public static OrderOuterClass.Order toUnsignedProtobuf(Order order) {
        OrderOuterClass.Order.Builder builder = OrderOuterClass.Order.newBuilder();
        if (order.type() == OrderType.BUY) {
            builder.setOrderSide(OrderOuterClass.Order.Side.BUY);
        } else if (order.type() == OrderType.SELL) {
            builder.setOrderSide(OrderOuterClass.Order.Side.SELL);
        }
        builder.setVersion(order.version()).setChainId((int)order.chainId()).setSenderPublicKey(ByteString.copyFrom((byte[])order.sender().bytes())).setAssetPair(OrderOuterClass.AssetPair.newBuilder().setAmountAssetId(ByteString.copyFrom((byte[])order.amount().assetId().bytes())).setPriceAssetId(ByteString.copyFrom((byte[])order.price().assetId().bytes())).build()).setAmount(order.amount().value()).setPrice(order.price().value()).setMatcherPublicKey(ByteString.copyFrom((byte[])order.matcher().bytes())).setMatcherFee(ProtobufConverter.amountToPBAmount(order.fee())).setTimestamp(order.timestamp()).setExpiration(order.expiration());
        return builder.build();
    }

    public static TransactionOuterClass.Transaction toUnsignedProtobuf(Transaction tx) {
        TransactionOuterClass.Transaction.Builder protoBuilder = TransactionOuterClass.Transaction.newBuilder().setVersion(tx.version()).setChainId((int)tx.chainId()).setSenderPublicKey(ByteString.copyFrom((byte[])tx.sender().bytes())).setFee(ProtobufConverter.amountToPBAmount(tx.fee())).setTimestamp(tx.timestamp());
        if (tx instanceof GenesisTransaction) {
            GenesisTransaction gtx = (GenesisTransaction)tx;
            protoBuilder.setGenesis(TransactionOuterClass.GenesisTransactionData.newBuilder().setRecipientAddress(ByteString.copyFrom((byte[])gtx.recipient().bytes())).setAmount(gtx.amount()).build());
        } else if (tx instanceof PaymentTransaction) {
            PaymentTransaction ptx = (PaymentTransaction)tx;
            protoBuilder.setPayment(TransactionOuterClass.PaymentTransactionData.newBuilder().setRecipientAddress(ByteString.copyFrom((byte[])ptx.recipient().bytes())).setAmount(ptx.amount()).build());
        } else if (tx instanceof IssueTransaction) {
            IssueTransaction itx = (IssueTransaction)tx;
            protoBuilder.setIssue(TransactionOuterClass.IssueTransactionData.newBuilder().setNameBytes(ByteString.copyFrom((byte[])itx.nameBytes())).setDescriptionBytes(ByteString.copyFrom((byte[])itx.descriptionBytes())).setAmount(itx.quantity()).setDecimals(itx.decimals()).setReissuable(itx.reissuable()).setScript(ByteString.copyFrom((byte[])itx.script().bytes())).build());
        } else if (tx instanceof TransferTransaction) {
            TransferTransaction ttx = (TransferTransaction)tx;
            protoBuilder.setTransfer(TransactionOuterClass.TransferTransactionData.newBuilder().setRecipient(ProtobufConverter.recipientToProto(ttx.recipient())).setAmount(AmountOuterClass.Amount.newBuilder().setAmount(ttx.amount().value()).setAssetId(ByteString.copyFrom((byte[])ttx.amount().assetId().bytes())).build()).setAttachment(ByteString.copyFrom((byte[])ttx.attachment().bytes())).build());
        } else if (tx instanceof ReissueTransaction) {
            ReissueTransaction rtx = (ReissueTransaction)tx;
            protoBuilder.setReissue(TransactionOuterClass.ReissueTransactionData.newBuilder().setAssetAmount(AmountOuterClass.Amount.newBuilder().setAssetId(ByteString.copyFrom((byte[])rtx.amount().assetId().bytes())).setAmount(rtx.amount().value()).build()).setReissuable(rtx.reissuable()).build());
        } else if (tx instanceof BurnTransaction) {
            BurnTransaction btx = (BurnTransaction)tx;
            protoBuilder.setBurn(TransactionOuterClass.BurnTransactionData.newBuilder().setAssetAmount(AmountOuterClass.Amount.newBuilder().setAssetId(ByteString.copyFrom((byte[])btx.amount().assetId().bytes())).setAmount(btx.amount().value()).build()).build());
        } else if (tx instanceof ExchangeTransaction) {
            ExchangeTransaction etx = (ExchangeTransaction)tx;
            OrderOuterClass.Order order1 = ProtobufConverter.toProtobuf(etx.orders().get(0));
            OrderOuterClass.Order order2 = ProtobufConverter.toProtobuf(etx.orders().get(1));
            protoBuilder.setExchange(TransactionOuterClass.ExchangeTransactionData.newBuilder().addOrders(order1).addOrders(order2).setAmount(etx.amount()).setPrice(etx.price()).setBuyMatcherFee(etx.buyMatcherFee()).setSellMatcherFee(etx.sellMatcherFee()).build());
        } else if (tx instanceof LeaseTransaction) {
            LeaseTransaction ltx = (LeaseTransaction)tx;
            protoBuilder.setLease(TransactionOuterClass.LeaseTransactionData.newBuilder().setRecipient(ProtobufConverter.recipientToProto(ltx.recipient())).setAmount(ltx.amount()).build());
        } else if (tx instanceof LeaseCancelTransaction) {
            LeaseCancelTransaction lctx = (LeaseCancelTransaction)tx;
            protoBuilder.setLeaseCancel(TransactionOuterClass.LeaseCancelTransactionData.newBuilder().setLeaseId(ByteString.copyFrom((byte[])lctx.leaseId().bytes())).build());
        } else if (tx instanceof CreateAliasTransaction) {
            CreateAliasTransaction caTx = (CreateAliasTransaction)tx;
            protoBuilder.setCreateAlias(TransactionOuterClass.CreateAliasTransactionData.newBuilder().setAliasBytes(ByteString.copyFrom((byte[])caTx.alias().name().getBytes(StandardCharsets.UTF_8))).build());
        } else if (tx instanceof MassTransferTransaction) {
            MassTransferTransaction mtTx = (MassTransferTransaction)tx;
            protoBuilder.setMassTransfer(TransactionOuterClass.MassTransferTransactionData.newBuilder().addAllTransfers((Iterable)mtTx.transfers().stream().map(t -> TransactionOuterClass.MassTransferTransactionData.Transfer.newBuilder().setRecipient(ProtobufConverter.recipientToProto(t.recipient())).setAmount(t.amount()).build()).collect(Collectors.toList())).setAssetId(ByteString.copyFrom((byte[])mtTx.assetId().bytes())).setAttachment(ByteString.copyFrom((byte[])mtTx.attachment().bytes()))).build();
        } else if (tx instanceof DataTransaction) {
            DataTransaction dtx = (DataTransaction)tx;
            protoBuilder.setDataTransaction(TransactionOuterClass.DataTransactionData.newBuilder().addAllData((Iterable)dtx.data().stream().map(e -> {
                TransactionOuterClass.DataTransactionData.DataEntry.Builder builder = TransactionOuterClass.DataTransactionData.DataEntry.newBuilder().setKey(e.key());
                if (e instanceof BinaryEntry) {
                    builder.setBinaryValue(ByteString.copyFrom((byte[])((BinaryEntry)e).value().bytes())).build();
                } else if (e instanceof BooleanEntry) {
                    builder.setBoolValue(((BooleanEntry)e).value()).build();
                } else if (e instanceof IntegerEntry) {
                    builder.setIntValue(((IntegerEntry)e).value()).build();
                } else if (e instanceof StringEntry) {
                    builder.setStringValue(((StringEntry)e).value()).build();
                } else if (e instanceof DeleteEntry) {
                    builder.setKey(e.key());
                } else {
                    throw new IllegalArgumentException("Unknown entry type " + (Object)((Object)e.type()));
                }
                return builder.build();
            }).collect(Collectors.toList())).build());
        } else if (tx instanceof SetScriptTransaction) {
            SetScriptTransaction ssTx = (SetScriptTransaction)tx;
            protoBuilder.setSetScript(TransactionOuterClass.SetScriptTransactionData.newBuilder().setScript(ByteString.copyFrom((byte[])ssTx.script().bytes())).build());
        } else if (tx instanceof SponsorFeeTransaction) {
            SponsorFeeTransaction sfTx = (SponsorFeeTransaction)tx;
            protoBuilder.setSponsorFee(TransactionOuterClass.SponsorFeeTransactionData.newBuilder().setMinFee(AmountOuterClass.Amount.newBuilder().setAssetId(ByteString.copyFrom((byte[])sfTx.assetId().bytes())).setAmount(sfTx.minSponsoredFee()).build()).build());
        } else if (tx instanceof SetAssetScriptTransaction) {
            SetAssetScriptTransaction sasTx = (SetAssetScriptTransaction)tx;
            protoBuilder.setSetAssetScript(TransactionOuterClass.SetAssetScriptTransactionData.newBuilder().setAssetId(ByteString.copyFrom((byte[])sasTx.assetId().bytes())).setScript(ByteString.copyFrom((byte[])sasTx.script().bytes())).build());
        } else if (tx instanceof InvokeScriptTransaction) {
            InvokeScriptTransaction isTx = (InvokeScriptTransaction)tx;
            TransactionOuterClass.InvokeScriptTransactionData.Builder invoke = TransactionOuterClass.InvokeScriptTransactionData.newBuilder();
            invoke.setDApp(ProtobufConverter.recipientToProto(isTx.dApp()));
            invoke.setFunctionCall(ByteString.copyFrom((byte[])new BytesWriter().writeFunction(isTx.function()).getBytes()));
            isTx.payments().forEach(p -> invoke.addPayments(AmountOuterClass.Amount.newBuilder().setAmount(p.value()).setAssetId(ByteString.copyFrom((byte[])p.assetId().bytes())).build()));
            protoBuilder.setInvokeScript(invoke.build());
        } else if (tx instanceof UpdateAssetInfoTransaction) {
            UpdateAssetInfoTransaction uaiTx = (UpdateAssetInfoTransaction)tx;
            protoBuilder.setUpdateAssetInfo(TransactionOuterClass.UpdateAssetInfoTransactionData.newBuilder().setAssetId(ByteString.copyFrom((byte[])uaiTx.assetId().bytes())).setName(uaiTx.name()).setDescription(uaiTx.description()).build());
        }
        return protoBuilder.build();
    }

    public static OrderOuterClass.Order toProtobuf(Order order) {
        return OrderOuterClass.Order.newBuilder((OrderOuterClass.Order)ProtobufConverter.toUnsignedProtobuf(order)).setEip712Signature(order.eip712Signature() == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])order.eip712Signature())).addAllProofs((Iterable)order.proofs().stream().map(p -> ByteString.copyFrom((byte[])p.bytes())).collect(Collectors.toList())).build();
    }

    public static TransactionOuterClass.SignedTransaction toProtobuf(Transaction tx) {
        return TransactionOuterClass.SignedTransaction.newBuilder().setWavesTransaction(ProtobufConverter.toUnsignedProtobuf(tx)).addAllProofs((Iterable)tx.proofs().stream().map(p -> ByteString.copyFrom((byte[])p.bytes())).collect(Collectors.toList())).build();
    }

    public static Recipient recipientFromProto(RecipientOuterClass.Recipient proto, byte chainId) {
        if (proto.getRecipientCase().getNumber() == 1) {
            return Address.fromPart(chainId, proto.getPublicKeyHash().toByteArray());
        }
        if (proto.getRecipientCase().getNumber() == 2) {
            return Alias.as(chainId, proto.getAlias());
        }
        throw new IllegalArgumentException("Protobuf recipient must be specified");
    }

    public static RecipientOuterClass.Recipient recipientToProto(Recipient recipient) {
        RecipientOuterClass.Recipient.Builder proto = RecipientOuterClass.Recipient.newBuilder();
        if (recipient.type() == 2) {
            proto.setAlias(((Alias)recipient).name());
        } else {
            proto.setPublicKeyHash(ByteString.copyFrom((byte[])((Address)recipient).publicKeyHash()));
        }
        return proto.build();
    }

    public static Amount pbAmountToAmount(AmountOuterClass.Amount amount) {
        return Amount.of(amount.getAmount(), AssetId.as(amount.getAssetId().toByteArray()));
    }

    public static AmountOuterClass.Amount amountToPBAmount(Amount amount) {
        return AmountOuterClass.Amount.newBuilder().setAmount(amount.value()).setAssetId(ByteString.copyFrom((byte[])amount.assetId().bytes())).build();
    }
}

