/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.invocation;

import com.wavesplatform.transactions.invocation.Arg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Function {
    private final String name;
    private final List<Arg> args;

    public Function(String name, Arg ... args) {
        this(name, new ArrayList<Arg>(Arrays.asList(args)));
    }

    public Function(String name, List<Arg> args) {
        this.name = name;
        this.args = args == null ? Collections.emptyList() : args;
    }

    public static Function asDefault() {
        return Function.as(null, new Arg[0]);
    }

    public static Function as(String name, Arg ... args) {
        return new Function(name, args);
    }

    public static Function as(String name, List<Arg> args) {
        return new Function(name, args);
    }

    public String name() {
        return this.name == null ? "" : this.name;
    }

    public List<Arg> args() {
        return this.args;
    }

    public boolean isDefault() {
        return this.name == null && this.args.size() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Function that = (Function)o;
        return Objects.equals(this.name, that.name) && this.args.equals(that.args);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.args);
    }

    public String toString() {
        return "Function{name='" + this.name + '\'' + ", args=" + this.args + '}';
    }
}

