/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.invocation;

import com.wavesplatform.crypto.base.Base64;
import com.wavesplatform.transactions.invocation.ArgType;
import java.util.Objects;

public abstract class Arg {
    private final ArgType type;
    private final Object value;

    protected Arg(ArgType type, Object value) {
        if (type == null || value == null) {
            throw new IllegalArgumentException("Argument type and value can't be null");
        }
        this.type = type;
        this.value = value;
    }

    public ArgType type() {
        return this.type;
    }

    public Object valueAsObject() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Arg that = (Arg)o;
        return this.type.equals((Object)that.type) && this.value.equals(that.value) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public String toString() {
        String value = this.value instanceof byte[] ? Base64.encode((byte[])((byte[])this.value)) : (this.value instanceof Boolean ? String.valueOf((Boolean)this.value) : (this.value instanceof Long ? String.valueOf((Long)this.value) : (this.value instanceof String ? (String)this.value : "<unknown type>")));
        return "Arg{type=" + (Object)((Object)this.type) + ", value=" + value + '}';
    }
}

