/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.exchange;

import com.wavesplatform.transactions.common.AssetId;
import java.util.Objects;

public class AssetPair {
    private final AssetId left;
    private final AssetId right;

    public AssetPair(AssetId left, AssetId right) {
        this.left = left == null ? AssetId.WAVES : left;
        this.right = right == null ? AssetId.WAVES : right;
    }

    public static AssetPair of(AssetId left, AssetId right) {
        return new AssetPair(left, right);
    }

    public AssetId left() {
        return this.left;
    }

    public AssetId right() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetPair assetPair = (AssetPair)o;
        return this.left.equals(assetPair.left) && this.right.equals(assetPair.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public String toString() {
        return "AssetPair{left=" + this.left + ", right=" + this.right + '}';
    }
}

