/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.data;

import com.wavesplatform.crypto.base.Base64;
import com.wavesplatform.transactions.data.EntryType;
import java.util.Objects;

public abstract class DataEntry {
    private final String key;
    private final EntryType type;
    private final Object value;

    protected DataEntry(String key, EntryType type, Object value) {
        this.key = key == null ? "" : key;
        this.type = type == null ? EntryType.DELETE : type;
        this.value = value;
    }

    public String key() {
        return this.key;
    }

    public EntryType type() {
        return this.type;
    }

    public Object valueAsObject() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataEntry that = (DataEntry)o;
        return this.key.equals(that.key) && this.type == that.type && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.type, this.value});
    }

    public String toString() {
        String value = this.value == null ? "" : (this.value instanceof byte[] ? Base64.encode((byte[])((byte[])this.value)) : (this.value instanceof Boolean ? String.valueOf((Boolean)this.value) : (this.value instanceof Long ? String.valueOf((Long)this.value) : (this.value instanceof String ? (String)this.value : "<unknown type>"))));
        return "DataEntry{key='" + this.key + '\'' + ", type=" + (Object)((Object)this.type) + ", value=" + value + '}';
    }
}

