/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.common;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.wavesplatform.crypto.Bytes;
import com.wavesplatform.crypto.base.Base64;
import com.wavesplatform.transactions.common.ByteString;
import java.util.Arrays;

public class Base64String
implements ByteString {
    private final byte[] bytes;
    private final java.util.function.Supplier<String> encoded;

    public static Base64String empty() {
        return new Base64String(Bytes.empty());
    }

    public Base64String(byte[] bytes) throws IllegalArgumentException {
        this.bytes = bytes == null ? Bytes.empty() : bytes;
        this.encoded = () -> ((Supplier)Suppliers.memoize(() -> Base64.encode((byte[])this.bytes))).get();
    }

    public Base64String(String encoded) throws IllegalArgumentException {
        this(Base64.decode((String)(encoded == null ? "" : encoded)));
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public String encoded() {
        return this.encoded.get();
    }

    @Override
    public String encodedWithPrefix() {
        return "base64:" + this.encoded();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!ByteString.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        ByteString that = (ByteString)o;
        return Arrays.equals(this.bytes, that.bytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return this.encoded();
    }
}

