/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.common;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.wavesplatform.crypto.Bytes;
import com.wavesplatform.crypto.base.Base58;
import com.wavesplatform.transactions.common.ByteString;
import java.util.Arrays;

public class Base58String
implements ByteString {
    protected final byte[] bytes;
    private final java.util.function.Supplier<String> encoded;

    public static Base58String empty() {
        return new Base58String(Bytes.empty());
    }

    public Base58String(byte[] bytes) throws IllegalArgumentException {
        this.bytes = bytes == null ? Bytes.empty() : bytes;
        this.encoded = () -> ((Supplier)Suppliers.memoize(() -> Base58.encode((byte[])this.bytes))).get();
    }

    public Base58String(String encoded) throws IllegalArgumentException {
        this(Base58.decode((String)(encoded == null ? "" : encoded)));
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public String encoded() {
        return this.encoded.get();
    }

    @Override
    public String encodedWithPrefix() {
        return "base58:" + this.encoded();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!ByteString.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        ByteString that = (ByteString)o;
        return Arrays.equals(this.bytes, that.bytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return this.encoded();
    }
}

