/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavesplatform.transactions.common.AssetId;
import java.util.Objects;

public class Amount {
    private final long value;
    private final AssetId assetId;

    @JsonCreator
    public Amount(@JsonProperty(value="amount") long value, @JsonProperty(value="assetId") AssetId assetId) {
        this.value = value;
        this.assetId = assetId == null ? AssetId.WAVES : assetId;
    }

    public Amount(long value) {
        this(value, AssetId.WAVES);
    }

    public static Amount of(long value, AssetId assetId) {
        return new Amount(value, assetId);
    }

    public static Amount of(long value) {
        return new Amount(value);
    }

    public long value() {
        return this.value;
    }

    public AssetId assetId() {
        return this.assetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Amount that = (Amount)o;
        return this.value == that.value && this.assetId.equals(that.assetId);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.assetId);
    }

    public String toString() {
        return "Amount{value=" + this.value + ", asset=" + this.assetId + '}';
    }
}

