/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.common;

import com.wavesplatform.crypto.Bytes;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.common.Recipient;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class Alias
implements Recipient {
    public static final String PREFIX = "alias:";
    public static final byte TYPE = 2;
    public static final int MIN_LENGTH = 4;
    public static final int MAX_LENGTH = 30;
    public static final int BYTES_LENGTH = 32;
    private static final String ALPHABET = "-.0-9@_a-z";
    private final byte[] bytes;
    private final String name;
    private final String fullAlias;

    public Alias(String name) {
        this(WavesConfig.chainId(), name);
    }

    public Alias(byte chainId, String name) {
        if (!Alias.isValid(chainId, name)) {
            throw new IllegalArgumentException("Alias must be 4 to 30 long of -.0-9@_a-z characters and may have a prefix 'alias:" + (char)chainId + ":', but actual is '" + name + "'");
        }
        this.name = name.replaceFirst("^alias:" + (char)chainId + ":", "");
        this.bytes = Bytes.concat((byte[][])new byte[][]{Bytes.of((byte[])new byte[]{2, chainId}), Bytes.toSizedByteArray((byte[])this.name.getBytes(StandardCharsets.UTF_8))});
        this.fullAlias = PREFIX + (char)this.bytes[1] + ":" + this.name;
    }

    public static boolean isValid(String alias) {
        return Alias.isValid(WavesConfig.chainId(), alias);
    }

    public static boolean isValid(byte chainId, String alias) {
        String maybeAlias = alias.replaceFirst("^alias:" + (char)chainId + ":", "");
        return maybeAlias.matches("[-.0-9@_a-z]{4,30}");
    }

    public static Alias as(String alias) {
        return new Alias(alias);
    }

    public static Alias as(byte chainId, String value) {
        return new Alias(chainId, value);
    }

    @Override
    public byte type() {
        return 2;
    }

    @Override
    public byte chainId() {
        return this.bytes[1];
    }

    public String name() {
        return this.name;
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alias alias = (Alias)o;
        return Arrays.equals(this.bytes, alias.bytes) && Objects.equals(this.name, alias.name) && Objects.equals(this.fullAlias, alias.fullAlias);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.fullAlias);
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public String toString() {
        return this.fullAlias;
    }
}

