/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.account;

import com.wavesplatform.crypto.Crypto;
import com.wavesplatform.crypto.Hash;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PrivateKey;
import com.wavesplatform.transactions.common.Base58String;
import java.util.Arrays;

public class PublicKey
extends Base58String {
    public static final int BYTES_LENGTH = 32;
    public static final int ETH_BYTES_LENGTH = 64;
    public static final PublicKey ZERO = PublicKey.as(new byte[32]);

    public static PublicKey from(PrivateKey privateKey) {
        return new PublicKey(privateKey);
    }

    public static PublicKey as(String base58Encoded) {
        return new PublicKey(base58Encoded);
    }

    public static PublicKey as(byte[] bytes) {
        return new PublicKey(bytes);
    }

    public PublicKey(PrivateKey privateKey) {
        this(Crypto.getPublicKey((byte[])privateKey.bytes()));
    }

    public PublicKey(String publicKey) {
        super(publicKey);
    }

    public PublicKey(byte[] publicKey) {
        super(publicKey);
        if (publicKey.length != 32 && publicKey.length != 64) {
            throw new IllegalArgumentException("Public key has wrong size in bytes. Expected: 32, actual: " + publicKey.length);
        }
    }

    public Address address(byte chainId) {
        return this.bytes.length == 32 ? Address.from(chainId, this) : Address.fromPart(chainId, Arrays.copyOfRange(Hash.keccak((byte[])this.bytes), 12, 32));
    }

    public Address address() {
        return this.address(WavesConfig.chainId());
    }

    public boolean isSignatureValid(byte[] message, byte[] signature) {
        if (signature.length != 64) {
            throw new IllegalArgumentException("Signature has wrong size in bytes. Expected: 64, actual: " + signature.length);
        }
        return Crypto.isProofValid((byte[])this.bytes, (byte[])message, (byte[])signature);
    }

    public boolean equals(byte[] anotherKey) {
        return Arrays.equals(this.bytes, anotherKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKey publicKey = (PublicKey)o;
        return Arrays.equals(this.bytes, publicKey.bytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public String toString() {
        return this.encoded();
    }
}

