/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.account;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.wavesplatform.crypto.Crypto;
import com.wavesplatform.crypto.base.Base58;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Base58String;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class PrivateKey
extends Base58String {
    public static final int LENGTH = 32;
    private final java.util.function.Supplier<PublicKey> publicKey;

    public static PrivateKey fromSeed(byte[] seedPhraseBytes, int nonce) {
        return new PrivateKey(Crypto.getPrivateKey((byte[])Crypto.getAccountSeed((byte[])seedPhraseBytes, (int)nonce)));
    }

    public static PrivateKey fromSeed(byte[] seedPhraseBytes) {
        return PrivateKey.fromSeed(seedPhraseBytes, 0);
    }

    public static PrivateKey fromSeed(String seedPhrase, int nonce) {
        return PrivateKey.fromSeed(seedPhrase.getBytes(StandardCharsets.UTF_8), nonce);
    }

    public static PrivateKey fromSeed(String seedPhrase) {
        return PrivateKey.fromSeed(seedPhrase.getBytes(StandardCharsets.UTF_8));
    }

    public static PrivateKey as(String base58Encoded) {
        return new PrivateKey(base58Encoded);
    }

    public static PrivateKey as(byte[] bytes) {
        return new PrivateKey(bytes);
    }

    public PrivateKey(String base58Encoded) {
        this(Base58.decode((String)base58Encoded));
    }

    public PrivateKey(byte[] privateKey) {
        super(privateKey);
        if (privateKey.length != 32) {
            throw new IllegalArgumentException("Private key has wrong size in bytes. Expected: 32, actual: " + privateKey.length);
        }
        this.publicKey = () -> ((Supplier)Suppliers.memoize(() -> PublicKey.from(this))).get();
    }

    @Override
    public byte[] bytes() {
        return (byte[])this.bytes.clone();
    }

    public PublicKey publicKey() {
        return this.publicKey.get();
    }

    public Address address(byte chainId) {
        return this.publicKey().address(chainId);
    }

    public Address address() {
        return this.address(WavesConfig.chainId());
    }

    public byte[] sign(byte[] message) {
        return Crypto.sign((byte[])this.bytes, (byte[])message);
    }

    public boolean isSignatureValid(byte[] message, byte[] signature) {
        return this.publicKey().isSignatureValid(message, signature);
    }

    public boolean equals(byte[] anotherKey) {
        return Arrays.equals(this.bytes, anotherKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivateKey that = (PrivateKey)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public String toString() {
        return this.encoded();
    }
}

