/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions.account;

import com.wavesplatform.crypto.Bytes;
import com.wavesplatform.crypto.Crypto;
import com.wavesplatform.crypto.Hash;
import com.wavesplatform.crypto.base.Base58;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Base58String;
import com.wavesplatform.transactions.common.Recipient;
import java.util.Arrays;

public class Address
extends Base58String
implements Recipient {
    private static final int CHECKSUM_LENGTH = 4;
    private static final int PUBLIC_KEY_HASH_LENGTH = 20;
    public static final String PREFIX = "address:";
    public static final byte TYPE = 1;
    public static final int BYTES_LENGTH = 26;
    public static final int STRING_LENGTH = (int)Math.ceil(Math.log(256.0) / Math.log(58.0) * 26.0);

    public static Address from(byte chainId, PublicKey publicKey) {
        return new Address(chainId, publicKey);
    }

    public static Address fromPart(byte chainId, byte[] publicKeyHash) {
        return new Address(chainId, publicKeyHash);
    }

    public static Address as(String base58Encoded) {
        return new Address(base58Encoded);
    }

    public static Address as(byte[] bytes) {
        return new Address(bytes);
    }

    public static boolean isValid(byte chainId, String address) {
        try {
            return Address.isValid(chainId, Base58.decode((String)address));
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static boolean isValid(String address) {
        try {
            return Address.isValid(Base58.decode((String)address));
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static boolean isValid(byte chainId, byte[] addressBytes) {
        return Address.isValid(addressBytes) && addressBytes[1] == chainId;
    }

    public static boolean isValid(byte[] addressBytes) {
        try {
            new Address(addressBytes);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public Address(byte chainId, PublicKey publicKey) {
        this(chainId, Crypto.getPublicKeyHash((byte[])publicKey.bytes()));
    }

    public Address(byte chainId, byte[] publicKeyHash) {
        super(Crypto.getAddress((byte)chainId, (byte[])publicKeyHash));
    }

    public Address(String address) {
        super(Base58.decode((String)address));
    }

    public Address(byte[] addressBytes) {
        super(addressBytes);
        if (addressBytes.length != 26) {
            throw new IllegalArgumentException("Address has wrong length. Expected: 26 bytes, actual: " + addressBytes.length + " bytes");
        }
        if (addressBytes[0] != 1) {
            throw new IllegalArgumentException("Address has unknown version " + addressBytes[0] + ". Expected: " + 1);
        }
        byte[][] parts = Bytes.chunk((byte[])addressBytes, (int[])new int[]{22, 4});
        byte[] checkSumPrefix = Bytes.chunk((byte[])Hash.secureHash((byte[])parts[0]), (int[])new int[]{4})[0];
        if (!Bytes.equal((byte[][])new byte[][]{parts[1], checkSumPrefix})) {
            throw new IllegalArgumentException(String.format("Address has wrong checksum base58:%s instead of base58:%s", Base58.encode((byte[])parts[1]), Base58.encode((byte[])checkSumPrefix)));
        }
    }

    @Override
    public byte type() {
        return 1;
    }

    @Override
    public byte chainId() {
        return this.bytes[1];
    }

    public byte[] publicKeyHash() {
        return Bytes.chunk((byte[])this.bytes(), (int[])new int[]{2, 20})[1];
    }

    public byte[] checksum() {
        return Bytes.chunk((byte[])this.bytes(), (int[])new int[]{22})[1];
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Arrays.equals(this.bytes, address.bytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public String toString() {
        return this.encoded();
    }
}

