/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Proof;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class UpdateAssetInfoTransaction
extends Transaction {
    public static final int TYPE = 17;
    public static final int LATEST_VERSION = 1;
    public static final long MIN_FEE = 100000L;
    private final AssetId assetId;
    private final String name;
    private final String description;

    public UpdateAssetInfoTransaction(PublicKey sender, AssetId assetId, String name, String description) {
        this(sender, assetId, name, description, WavesConfig.chainId(), Amount.of(100000L), System.currentTimeMillis(), 1, Proof.emptyList());
    }

    public UpdateAssetInfoTransaction(PublicKey sender, AssetId assetId, String name, String description, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(17, version, chainId, sender, fee, timestamp, proofs);
        if (assetId.isWaves()) {
            throw new IllegalArgumentException("Can't be Waves");
        }
        this.assetId = assetId;
        this.name = name == null ? "" : name;
        this.description = description == null ? "" : description;
    }

    public static UpdateAssetInfoTransaction fromBytes(byte[] bytes) throws IOException {
        return (UpdateAssetInfoTransaction)Transaction.fromBytes(bytes);
    }

    public static UpdateAssetInfoTransaction fromJson(String json) throws IOException {
        return (UpdateAssetInfoTransaction)Transaction.fromJson(json);
    }

    public static UpdateAssetInfoTransactionBuilder builder(AssetId assetId, String name, String description) {
        return new UpdateAssetInfoTransactionBuilder(assetId, name, description);
    }

    public AssetId assetId() {
        return this.assetId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpdateAssetInfoTransaction that = (UpdateAssetInfoTransaction)o;
        return this.assetId.equals(that.assetId) && this.name.equals(that.name) && this.description.equals(that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.assetId, this.name, this.description);
    }

    public static class UpdateAssetInfoTransactionBuilder
    extends Transaction.TransactionBuilder<UpdateAssetInfoTransactionBuilder, UpdateAssetInfoTransaction> {
        private final AssetId assetId;
        private final String name;
        private final String description;

        protected UpdateAssetInfoTransactionBuilder(AssetId assetId, String name, String description) {
            super(1, 100000L);
            this.assetId = assetId;
            this.name = name;
            this.description = description;
        }

        @Override
        protected UpdateAssetInfoTransaction _build() {
            return new UpdateAssetInfoTransaction(this.sender, this.assetId, this.name, this.description, this.chainId, this.feeWithExtra(), this.timestamp, this.version, Proof.emptyList());
        }
    }
}

