/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.crypto.Bytes;
import com.wavesplatform.crypto.Hash;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PrivateKey;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.serializers.binary.BinarySerializer;
import com.wavesplatform.transactions.serializers.json.JsonSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class TransactionOrOrder {
    protected Id id = null;
    private final int version;
    private final byte chainId;
    private final PublicKey sender;
    private final Amount fee;
    private final long timestamp;
    private final List<Proof> proofs;
    private byte[] bodyBytes;

    protected TransactionOrOrder(int version, byte chainId, PublicKey sender, Amount fee, long timestamp, List<Proof> proofs) {
        this.version = version;
        this.chainId = chainId;
        this.sender = sender;
        this.fee = fee;
        this.timestamp = timestamp;
        this.proofs = proofs == null ? Proof.emptyList() : new ArrayList<Proof>(proofs);
    }

    public int version() {
        return this.version;
    }

    public byte chainId() {
        return this.chainId;
    }

    public PublicKey sender() {
        return this.sender;
    }

    public Amount fee() {
        return this.fee;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public List<Proof> proofs() {
        return this.proofs;
    }

    public byte[] bodyBytes() {
        if (this.bodyBytes == null) {
            this.bodyBytes = BinarySerializer.bodyBytes(this);
        }
        return this.bodyBytes;
    }

    public Id id() {
        if (this.id == null) {
            this.id = new Id(Hash.blake((byte[])this.bodyBytes()));
        }
        return this.id;
    }

    public <T extends TransactionOrOrder> T addProof(Proof proof) {
        this.proofs.add(proof);
        return (T)this;
    }

    public <T extends TransactionOrOrder> T addProof(PrivateKey privateKey) {
        this.addProof(Proof.as(privateKey.sign(this.bodyBytes())));
        return (T)this;
    }

    public <T extends TransactionOrOrder> T addProofs(List<Proof> proofs) {
        this.proofs.addAll(proofs);
        return (T)this;
    }

    public <T extends TransactionOrOrder> T setProof(int index, Proof proof) {
        for (int i = this.proofs.size(); i <= index; ++i) {
            this.proofs.add(Proof.as(Bytes.empty()));
        }
        this.proofs.set(index, proof);
        return (T)this;
    }

    public <T extends TransactionOrOrder> T setProof(int index, PrivateKey privateKey) {
        this.setProof(index, Proof.as(privateKey.sign(this.bodyBytes())));
        return (T)this;
    }

    public byte[] toBytes() {
        return BinarySerializer.toBytes(this);
    }

    public String toPrettyJson() {
        return JsonSerializer.toPrettyJson(this);
    }

    public String toJson() {
        return JsonSerializer.toJson(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionOrOrder that = (TransactionOrOrder)o;
        return Bytes.equal((byte[][])new byte[][]{this.bodyBytes(), that.bodyBytes()}) && this.proofs.equals(that.proofs);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.bodyBytes()), this.proofs);
    }

    public String toString() {
        return this.toJson();
    }

    protected static abstract class TransactionOrOrderBuilder<BUILDER extends TransactionOrOrderBuilder<BUILDER, TX_OR_ORDER>, TX_OR_ORDER extends TransactionOrOrder> {
        protected int version;
        protected byte chainId;
        protected PublicKey sender;
        protected long timestamp;
        protected Amount fee;
        protected long extraFee;

        protected TransactionOrOrderBuilder(int defaultVersion, long defaultFee) {
            this.version = defaultVersion;
            this.chainId = WavesConfig.chainId();
            this.fee = Amount.of(defaultFee);
            this.extraFee = 0L;
        }

        protected Amount feeWithExtra() {
            return Amount.of(this.fee.value() + this.extraFee, this.fee.assetId());
        }

        private BUILDER builder() {
            return (BUILDER)this;
        }

        public BUILDER version(int version) {
            this.version = version;
            return this.builder();
        }

        public BUILDER chainId(byte chainId) {
            this.chainId = chainId;
            return this.builder();
        }

        public BUILDER sender(PublicKey publicKey) {
            this.sender = publicKey;
            return this.builder();
        }

        public BUILDER fee(Amount fee) {
            this.fee = fee;
            return this.builder();
        }

        public BUILDER fee(long fee) {
            return this.fee(Amount.of(fee));
        }

        public BUILDER extraFee(long extraFee) {
            this.extraFee = extraFee;
            return this.builder();
        }

        public BUILDER timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this.builder();
        }

        public TX_OR_ORDER getUnsigned() {
            if (this.timestamp == 0L) {
                this.timestamp(System.currentTimeMillis());
            }
            return this._build();
        }

        public TX_OR_ORDER getSignedWith(PrivateKey signer) {
            if (this.sender == null) {
                this.sender = signer.publicKey();
            }
            return (TX_OR_ORDER)((TransactionOrOrder)this.getUnsigned()).addProof(signer);
        }

        protected abstract TX_OR_ORDER _build();
    }
}

