/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Proof;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class SponsorFeeTransaction
extends Transaction {
    public static final int TYPE = 14;
    public static final int LATEST_VERSION = 2;
    public static final long MIN_FEE = 100000L;
    private final AssetId assetId;
    private final long minSponsoredFee;

    public SponsorFeeTransaction(PublicKey sender, AssetId assetId, long minSponsoredFee) {
        this(sender, assetId, minSponsoredFee, WavesConfig.chainId(), Amount.of(100000L), System.currentTimeMillis(), 2, Proof.emptyList());
    }

    public SponsorFeeTransaction(PublicKey sender, AssetId assetId, long minSponsoredFee, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(14, version, chainId, sender, fee, timestamp, proofs);
        if (assetId.isWaves()) {
            throw new IllegalArgumentException("Can't be Waves");
        }
        this.assetId = assetId;
        this.minSponsoredFee = minSponsoredFee;
    }

    public static SponsorFeeTransaction fromBytes(byte[] bytes) throws IOException {
        return (SponsorFeeTransaction)Transaction.fromBytes(bytes);
    }

    public static SponsorFeeTransaction fromJson(String json) throws IOException {
        return (SponsorFeeTransaction)Transaction.fromJson(json);
    }

    public static SponsorFeeTransactionBuilder builder(AssetId assetId, long minSponsoredFee) {
        return new SponsorFeeTransactionBuilder(assetId, minSponsoredFee);
    }

    public AssetId assetId() {
        return this.assetId;
    }

    public long minSponsoredFee() {
        return this.minSponsoredFee;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SponsorFeeTransaction that = (SponsorFeeTransaction)o;
        return this.assetId.equals(that.assetId) && this.minSponsoredFee == that.minSponsoredFee;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.assetId, this.minSponsoredFee);
    }

    public static class SponsorFeeTransactionBuilder
    extends Transaction.TransactionBuilder<SponsorFeeTransactionBuilder, SponsorFeeTransaction> {
        private final AssetId assetId;
        private final long minSponsoredFee;

        protected SponsorFeeTransactionBuilder(AssetId assetId, long minSponsoredFee) {
            super(2, 100000L);
            this.assetId = assetId;
            this.minSponsoredFee = minSponsoredFee;
        }

        @Override
        protected SponsorFeeTransaction _build() {
            return new SponsorFeeTransaction(this.sender, this.assetId, this.minSponsoredFee, this.chainId, this.feeWithExtra(), this.timestamp, this.version, Proof.emptyList());
        }
    }
}

