/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Base64String;
import com.wavesplatform.transactions.common.Proof;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class SetScriptTransaction
extends Transaction {
    public static final int TYPE = 13;
    public static final int LATEST_VERSION = 2;
    public static final long MIN_FEE = 1000000L;
    private final Base64String script;

    public SetScriptTransaction(PublicKey sender, Base64String compiledScript) {
        this(sender, compiledScript, WavesConfig.chainId(), Amount.of(1000000L), System.currentTimeMillis(), 2, Proof.emptyList());
    }

    public SetScriptTransaction(PublicKey sender, Base64String compiledScript, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(13, version, chainId, sender, fee, timestamp, proofs);
        this.script = compiledScript == null ? Base64String.empty() : compiledScript;
    }

    public static SetScriptTransaction fromBytes(byte[] bytes) throws IOException {
        return (SetScriptTransaction)Transaction.fromBytes(bytes);
    }

    public static SetScriptTransaction fromJson(String json) throws IOException {
        return (SetScriptTransaction)Transaction.fromJson(json);
    }

    public static SetScriptTransactionBuilder builder(Base64String compiledScript) {
        return new SetScriptTransactionBuilder(compiledScript);
    }

    public Base64String script() {
        return this.script;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SetScriptTransaction that = (SetScriptTransaction)o;
        return this.script.equals(that.script);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.script);
    }

    public static class SetScriptTransactionBuilder
    extends Transaction.TransactionBuilder<SetScriptTransactionBuilder, SetScriptTransaction> {
        private final Base64String script;

        protected SetScriptTransactionBuilder(Base64String compiledScript) {
            super(2, 1000000L);
            this.script = compiledScript == null ? Base64String.empty() : compiledScript;
        }

        @Override
        protected SetScriptTransaction _build() {
            return new SetScriptTransaction(this.sender, this.script, this.chainId, this.feeWithExtra(), this.timestamp, this.version, Proof.emptyList());
        }
    }
}

