/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base64String;
import com.wavesplatform.transactions.common.Proof;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class SetAssetScriptTransaction
extends Transaction {
    public static final int TYPE = 15;
    public static final int LATEST_VERSION = 2;
    public static final long MIN_FEE = 100000000L;
    private final AssetId assetId;
    private final Base64String script;

    public SetAssetScriptTransaction(PublicKey sender, AssetId assetId, Base64String compiledScript) {
        this(sender, assetId, compiledScript, WavesConfig.chainId(), Amount.of(100000000L), System.currentTimeMillis(), 2, Proof.emptyList());
    }

    public SetAssetScriptTransaction(PublicKey sender, AssetId assetId, Base64String compiledScript, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(15, version, chainId, sender, fee, timestamp, proofs);
        if (assetId.isWaves()) {
            throw new IllegalArgumentException("Can't be Waves");
        }
        this.assetId = assetId;
        this.script = compiledScript == null ? Base64String.empty() : compiledScript;
    }

    public static SetAssetScriptTransaction fromBytes(byte[] bytes) throws IOException {
        return (SetAssetScriptTransaction)Transaction.fromBytes(bytes);
    }

    public static SetAssetScriptTransaction fromJson(String json) throws IOException {
        return (SetAssetScriptTransaction)Transaction.fromJson(json);
    }

    public static SetAssetScriptTransactionBuilder builder(AssetId assetId, Base64String compiledScript) {
        return new SetAssetScriptTransactionBuilder(assetId, compiledScript);
    }

    public AssetId assetId() {
        return this.assetId;
    }

    public Base64String script() {
        return this.script;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SetAssetScriptTransaction that = (SetAssetScriptTransaction)o;
        return this.assetId.equals(that.assetId) && this.script.equals(that.script);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.assetId, this.script);
    }

    public static class SetAssetScriptTransactionBuilder
    extends Transaction.TransactionBuilder<SetAssetScriptTransactionBuilder, SetAssetScriptTransaction> {
        private final AssetId assetId;
        private final Base64String script;

        protected SetAssetScriptTransactionBuilder(AssetId assetId, Base64String compiledScript) {
            super(2, 100000000L);
            this.assetId = assetId;
            this.script = compiledScript == null ? Base64String.empty() : compiledScript;
        }

        @Override
        protected SetAssetScriptTransaction _build() {
            return new SetAssetScriptTransaction(this.sender, this.assetId, this.script, this.chainId, this.feeWithExtra(), this.timestamp, this.version, Proof.emptyList());
        }
    }
}

