/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Proof;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class ReissueTransaction
extends Transaction {
    public static final int TYPE = 5;
    public static final int LATEST_VERSION = 3;
    public static final long MIN_FEE = 100000L;
    private final Amount amount;
    private final boolean reissuable;

    public ReissueTransaction(PublicKey sender, Amount amount, boolean reissuable) {
        this(sender, amount, reissuable, WavesConfig.chainId(), Amount.of(100000L), System.currentTimeMillis(), 3, Proof.emptyList());
    }

    public ReissueTransaction(PublicKey sender, Amount amount, boolean reissuable, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(5, version, chainId, sender, fee, timestamp, proofs);
        if (amount.assetId().isWaves()) {
            throw new IllegalArgumentException("Can't be Waves");
        }
        this.amount = amount;
        this.reissuable = reissuable;
    }

    public static ReissueTransaction fromBytes(byte[] bytes) throws IOException {
        return (ReissueTransaction)Transaction.fromBytes(bytes);
    }

    public static ReissueTransaction fromJson(String json) throws IOException {
        return (ReissueTransaction)Transaction.fromJson(json);
    }

    public static ReissueTransactionBuilder builder(Amount amount) {
        return new ReissueTransactionBuilder(amount);
    }

    public Amount amount() {
        return this.amount;
    }

    public boolean reissuable() {
        return this.reissuable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReissueTransaction that = (ReissueTransaction)o;
        return this.amount.equals(that.amount) && this.reissuable == that.reissuable;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.amount, this.reissuable);
    }

    public static class ReissueTransactionBuilder
    extends Transaction.TransactionBuilder<ReissueTransactionBuilder, ReissueTransaction> {
        private final Amount amount;
        private boolean reissuable;

        protected ReissueTransactionBuilder(Amount amount) {
            super(3, 100000L);
            this.amount = amount;
            this.reissuable = true;
        }

        public ReissueTransactionBuilder reissuable(boolean reissuable) {
            this.reissuable = reissuable;
            return this;
        }

        @Override
        protected ReissueTransaction _build() {
            return new ReissueTransaction(this.sender, this.amount, this.reissuable, this.chainId, this.feeWithExtra(), this.timestamp, this.version, Proof.emptyList());
        }
    }
}

