/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base58String;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.mass.Transfer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class MassTransferTransaction
extends Transaction {
    public static final int TYPE = 11;
    public static final int LATEST_VERSION = 2;
    public static final long MIN_FEE = 100000L;
    private final List<Transfer> transfers;
    private final AssetId assetId;
    private final Base58String attachment;

    public MassTransferTransaction(PublicKey sender, AssetId assetId, List<Transfer> transfers, Base58String attachment) {
        this(sender, assetId, transfers, attachment, WavesConfig.chainId(), Amount.of(0L), System.currentTimeMillis(), 2, Proof.emptyList());
    }

    public MassTransferTransaction(PublicKey sender, AssetId assetId, List<Transfer> transfers, Base58String attachment, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(11, version, chainId, sender, MassTransferTransaction.calculateFee(transfers, fee), timestamp, proofs);
        this.assetId = assetId == null ? AssetId.WAVES : assetId;
        this.transfers = transfers == null ? new ArrayList() : transfers;
        this.attachment = attachment == null ? Base58String.empty() : attachment;
    }

    public static MassTransferTransaction fromBytes(byte[] bytes) throws IOException {
        return (MassTransferTransaction)Transaction.fromBytes(bytes);
    }

    public static MassTransferTransaction fromJson(String json) throws IOException {
        return (MassTransferTransaction)Transaction.fromJson(json);
    }

    public static MassTransferTransactionBuilder builder(List<Transfer> transfers) {
        return new MassTransferTransactionBuilder(transfers);
    }

    public static MassTransferTransactionBuilder builder(Transfer ... transfers) {
        return MassTransferTransaction.builder(Arrays.asList(transfers));
    }

    private static Amount calculateFee(List<Transfer> transfers, Amount fee) {
        if (fee.value() > 0L) {
            return fee;
        }
        if (transfers == null) {
            return Amount.of(100000L);
        }
        return Amount.of(100000L * (long)(1 + (transfers.size() + 1) / 2));
    }

    public long total() {
        return this.transfers.stream().mapToLong(Transfer::amount).sum();
    }

    public List<Transfer> transfers() {
        return this.transfers;
    }

    public AssetId assetId() {
        return this.assetId;
    }

    public Base58String attachment() {
        return this.attachment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MassTransferTransaction that = (MassTransferTransaction)o;
        return this.transfers.equals(that.transfers) && this.assetId.equals(that.assetId) && this.attachment.equals(that.attachment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.transfers, this.assetId, this.attachment);
    }

    public static class MassTransferTransactionBuilder
    extends Transaction.TransactionBuilder<MassTransferTransactionBuilder, MassTransferTransaction> {
        private final List<Transfer> transfers;
        private AssetId assetId;
        private Base58String attachment;

        protected MassTransferTransactionBuilder(List<Transfer> transfers) {
            super(2, 0L);
            this.transfers = transfers;
            this.assetId = AssetId.WAVES;
            this.attachment = Base58String.empty();
        }

        public MassTransferTransactionBuilder assetId(AssetId assetId) {
            this.assetId = assetId;
            return this;
        }

        public MassTransferTransactionBuilder attachment(Base58String attachment) {
            this.attachment = attachment;
            return this;
        }

        @Override
        protected MassTransferTransaction _build() {
            Amount calculatedFee = MassTransferTransaction.calculateFee(this.transfers, this.fee);
            Amount calculatedFeeWithExtra = Amount.of(calculatedFee.value() + this.extraFee, calculatedFee.assetId());
            return new MassTransferTransaction(this.sender, this.assetId, this.transfers, this.attachment, this.chainId, calculatedFeeWithExtra, this.timestamp, this.version, Proof.emptyList());
        }
    }
}

