/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.common.Recipient;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class LeaseTransaction
extends Transaction {
    public static final int TYPE = 8;
    public static final int LATEST_VERSION = 3;
    public static final long MIN_FEE = 100000L;
    private final Recipient recipient;
    private final long amount;

    public LeaseTransaction(PublicKey sender, Recipient recipient, long amount) {
        this(sender, recipient, amount, WavesConfig.chainId(), Amount.of(100000L), System.currentTimeMillis(), 3, Proof.emptyList());
    }

    public LeaseTransaction(PublicKey sender, Recipient recipient, long amount, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(8, version, chainId, sender, fee, timestamp, proofs);
        this.recipient = recipient;
        this.amount = amount;
    }

    public static LeaseTransaction fromBytes(byte[] bytes) throws IOException {
        return (LeaseTransaction)Transaction.fromBytes(bytes);
    }

    public static LeaseTransaction fromJson(String json) throws IOException {
        return (LeaseTransaction)Transaction.fromJson(json);
    }

    public static LeaseTransactionBuilder builder(Recipient recipient, long amount) {
        return new LeaseTransactionBuilder(recipient, amount);
    }

    public Recipient recipient() {
        return this.recipient;
    }

    public long amount() {
        return this.amount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LeaseTransaction that = (LeaseTransaction)o;
        return this.amount == that.amount && this.recipient.equals(that.recipient);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.recipient, this.amount);
    }

    public static class LeaseTransactionBuilder
    extends Transaction.TransactionBuilder<LeaseTransactionBuilder, LeaseTransaction> {
        private final Recipient recipient;
        private final long amount;

        protected LeaseTransactionBuilder(Recipient recipient, long amount) {
            super(3, 100000L);
            this.recipient = recipient;
            this.amount = amount;
        }

        @Override
        protected LeaseTransaction _build() {
            return new LeaseTransaction(this.sender, this.recipient, this.amount, this.chainId, this.feeWithExtra(), this.timestamp, this.version, Proof.emptyList());
        }
    }
}

