/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.crypto.Bytes;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Base64String;
import com.wavesplatform.transactions.common.Proof;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public class IssueTransaction
extends Transaction {
    public static final int TYPE = 3;
    public static final int LATEST_VERSION = 3;
    public static final long MIN_FEE = 100000000L;
    public static final long NFT_MIN_FEE = 100000L;
    private final byte[] name;
    private final byte[] description;
    private final long quantity;
    private final int decimals;
    private final boolean isReissuable;
    private final Base64String script;

    public IssueTransaction(PublicKey sender, String name, String description, long quantity, int decimals, boolean isReissuable, Base64String compiledScript) {
        this(sender, name, description, quantity, decimals, isReissuable, compiledScript, WavesConfig.chainId(), Amount.of(100000000L), System.currentTimeMillis(), 3, Proof.emptyList());
    }

    public IssueTransaction(PublicKey sender, String name, String description, long quantity, int decimals, boolean isReissuable, Base64String compiledScript, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        this(sender, name == null ? Bytes.empty() : name.getBytes(StandardCharsets.UTF_8), description == null ? Bytes.empty() : description.getBytes(StandardCharsets.UTF_8), quantity, decimals, isReissuable, compiledScript, chainId, fee, timestamp, version, proofs);
    }

    @Deprecated
    public IssueTransaction(PublicKey sender, byte[] name, byte[] description, long quantity, int decimals, boolean isReissuable, Base64String compiledScript, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(3, version, chainId, sender, fee, timestamp, proofs);
        this.name = name == null ? Bytes.empty() : name;
        this.description = description == null ? Bytes.empty() : description;
        this.quantity = quantity;
        this.decimals = decimals;
        this.isReissuable = isReissuable;
        this.script = compiledScript == null ? Base64String.empty() : compiledScript;
    }

    public static IssueTransaction fromBytes(byte[] bytes) throws IOException {
        return (IssueTransaction)Transaction.fromBytes(bytes);
    }

    public static IssueTransaction fromJson(String json) throws IOException {
        return (IssueTransaction)Transaction.fromJson(json);
    }

    public static IssueTransactionBuilder builder(String name, long quantity, int decimals) {
        return new IssueTransactionBuilder(name, quantity, decimals);
    }

    public static IssueTransactionNFTBuilder builderNFT(String name) {
        return new IssueTransactionNFTBuilder(name);
    }

    public AssetId assetId() {
        return AssetId.as(this.id().bytes());
    }

    public String name() {
        return new String(this.name, StandardCharsets.UTF_8);
    }

    public byte[] nameBytes() {
        return this.name;
    }

    public String description() {
        return new String(this.description, StandardCharsets.UTF_8);
    }

    public byte[] descriptionBytes() {
        return this.description;
    }

    public long quantity() {
        return this.quantity;
    }

    public int decimals() {
        return this.decimals;
    }

    public boolean reissuable() {
        return this.isReissuable;
    }

    public Base64String script() {
        return this.script;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IssueTransaction that = (IssueTransaction)o;
        return Bytes.equal((byte[][])new byte[][]{this.name, that.name}) && Bytes.equal((byte[][])new byte[][]{this.description, that.description}) && this.quantity == that.quantity && this.decimals == that.decimals && this.isReissuable == that.isReissuable && this.script.equals(that.script);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.description, this.quantity, this.decimals, this.isReissuable, this.script);
    }

    public static class IssueTransactionNFTBuilder
    extends Transaction.TransactionBuilder<IssueTransactionNFTBuilder, IssueTransaction> {
        private final byte[] name;
        private byte[] description;
        private Base64String script;
        private static final long SINGLE_TOKEN = 1L;
        private static final int NO_DECIMALS = 0;
        private static final boolean NON_REISSUABLE = false;

        protected IssueTransactionNFTBuilder(String name) {
            super(3, 100000L);
            this.name = name == null ? Bytes.empty() : name.getBytes(StandardCharsets.UTF_8);
            this.description = Bytes.empty();
            this.script = Base64String.empty();
        }

        public IssueTransactionNFTBuilder description(String description) {
            this.description = description == null ? Bytes.empty() : description.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public IssueTransactionNFTBuilder script(Base64String compiledScript) {
            this.script = compiledScript == null ? Base64String.empty() : compiledScript;
            return this;
        }

        @Override
        protected IssueTransaction _build() {
            return new IssueTransaction(this.sender, this.name, this.description, 1L, 0, false, this.script, this.chainId, this.feeWithExtra(), this.timestamp, this.version, Proof.emptyList());
        }
    }

    public static class IssueTransactionBuilder
    extends Transaction.TransactionBuilder<IssueTransactionBuilder, IssueTransaction> {
        private final byte[] name;
        private byte[] description;
        private final long quantity;
        private final int decimals;
        private boolean isReissuable;
        private Base64String script;

        protected IssueTransactionBuilder(String name, long quantity, int decimals) {
            super(3, 100000000L);
            this.name = name == null ? Bytes.empty() : name.getBytes(StandardCharsets.UTF_8);
            this.quantity = quantity;
            this.decimals = decimals;
            this.description = Bytes.empty();
            this.isReissuable = true;
            this.script = Base64String.empty();
        }

        public IssueTransactionBuilder description(String description) {
            this.description = description.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public IssueTransactionBuilder isReissuable(boolean isReissuable) {
            this.isReissuable = isReissuable;
            return this;
        }

        public IssueTransactionBuilder script(Base64String compiledScript) {
            this.script = compiledScript == null ? Base64String.empty() : compiledScript;
            return this;
        }

        @Override
        protected IssueTransaction _build() {
            return new IssueTransaction(this.sender, this.name, this.description, this.quantity, this.decimals, this.isReissuable, this.script, this.chainId, this.fee, this.timestamp, this.version, Proof.emptyList());
        }
    }
}

