/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.common.Recipient;
import com.wavesplatform.transactions.invocation.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class InvokeScriptTransaction
extends Transaction {
    public static final int TYPE = 16;
    public static final int LATEST_VERSION = 2;
    public static final long MIN_FEE = 500000L;
    private final Recipient dApp;
    private final Function function;
    private final List<Amount> payments;

    public InvokeScriptTransaction(PublicKey sender, Recipient dApp, Function function, List<Amount> payments) {
        this(sender, dApp, function, payments, WavesConfig.chainId(), Amount.of(500000L), System.currentTimeMillis(), 2, Proof.emptyList());
    }

    public InvokeScriptTransaction(PublicKey sender, Recipient dApp, Function function, List<Amount> payments, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(16, version, chainId, sender, fee, timestamp, proofs);
        this.dApp = Objects.requireNonNull(dApp, "dApp can't be null");
        this.function = function == null ? Function.asDefault() : function;
        this.payments = payments == null ? Collections.emptyList() : payments;
    }

    public static InvokeScriptTransaction fromBytes(byte[] bytes) throws IOException {
        return (InvokeScriptTransaction)Transaction.fromBytes(bytes);
    }

    public static InvokeScriptTransaction fromJson(String json) throws IOException {
        return (InvokeScriptTransaction)Transaction.fromJson(json);
    }

    public static InvokeScriptTransactionBuilder builder(Recipient dApp, Function function) {
        return new InvokeScriptTransactionBuilder(dApp, function);
    }

    public Recipient dApp() {
        return this.dApp;
    }

    public Function function() {
        return this.function;
    }

    public List<Amount> payments() {
        return this.payments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvokeScriptTransaction that = (InvokeScriptTransaction)o;
        return this.dApp.equals(that.dApp) && this.function.equals(that.function) && this.payments.equals(that.payments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dApp, this.function, this.payments);
    }

    public static class InvokeScriptTransactionBuilder
    extends Transaction.TransactionBuilder<InvokeScriptTransactionBuilder, InvokeScriptTransaction> {
        private final Recipient dApp;
        private final Function function;
        private final List<Amount> payments;

        protected InvokeScriptTransactionBuilder(Recipient dApp, Function function) {
            super(2, 500000L);
            this.dApp = dApp;
            this.function = function;
            this.payments = new ArrayList<Amount>();
        }

        public InvokeScriptTransactionBuilder payments(Amount ... payments) {
            this.payments(Arrays.asList(payments));
            return this;
        }

        public InvokeScriptTransactionBuilder payments(List<Amount> payments) {
            this.payments.addAll(payments);
            return this;
        }

        @Override
        protected InvokeScriptTransaction _build() {
            return new InvokeScriptTransaction(this.sender, this.dApp, this.function, this.payments, this.chainId, this.feeWithExtra(), this.timestamp, this.version, Proof.emptyList());
        }
    }
}

