/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.crypto.Bytes;
import com.wavesplatform.crypto.Hash;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.serializers.binary.BytesWriter;
import java.io.IOException;
import java.util.Objects;

public class GenesisTransaction
extends Transaction {
    public static final int TYPE = 1;
    public static final int LATEST_VERSION = 1;
    private final Address recipient;
    private final long amount;

    public GenesisTransaction(Address recipient, long amount, long timestamp) {
        this(recipient, amount, timestamp, GenesisTransaction.generateSignature(recipient, amount, timestamp));
    }

    public GenesisTransaction(Address recipient, long amount, long timestamp, Proof signature) {
        super(1, 1, recipient.chainId(), PublicKey.as(new byte[32]), Amount.of(0L), timestamp, Proof.list(signature));
        this.recipient = recipient;
        this.amount = amount;
    }

    private static Proof generateSignature(Address recipient, long amount, long timestamp) {
        byte[] message = new BytesWriter().writeInt(1).writeLong(timestamp).write(recipient.bytes()).writeLong(amount).getBytes();
        byte[] hash = Hash.blake((byte[])message);
        return Proof.as(Bytes.concat((byte[][])new byte[][]{hash, hash}));
    }

    public static GenesisTransaction fromBytes(byte[] bytes) throws IOException {
        return (GenesisTransaction)Transaction.fromBytes(bytes);
    }

    public static GenesisTransaction fromJson(String json) throws IOException {
        return (GenesisTransaction)Transaction.fromJson(json);
    }

    @Override
    public Id id() {
        return Id.as(this.proofs().get(0).bytes());
    }

    public Address recipient() {
        return this.recipient;
    }

    public long amount() {
        return this.amount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenesisTransaction that = (GenesisTransaction)o;
        return this.recipient.equals(that.recipient) && this.amount == that.amount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.recipient, this.amount);
    }
}

