/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.crypto.base.Base58;
import com.wavesplatform.events.protobuf.Events;
import com.wavesplatform.protobuf.transaction.TransactionOuterClass;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.TransactionOrOrder;
import com.wavesplatform.transactions.account.Address;
import com.wavesplatform.transactions.account.PrivateKey;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.AssetId;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.invocation.Arg;
import com.wavesplatform.transactions.invocation.BinaryArg;
import com.wavesplatform.transactions.invocation.BooleanArg;
import com.wavesplatform.transactions.invocation.Function;
import com.wavesplatform.transactions.invocation.IntegerArg;
import com.wavesplatform.transactions.invocation.ListArg;
import com.wavesplatform.transactions.invocation.StringArg;
import com.wavesplatform.transactions.serializers.ProtobufConverter;
import com.wavesplatform.transactions.serializers.eth.EthFunctionEncoder;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.web3j.abi.TypeEncoder;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Int64;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.ECDSASignature;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.SignedRawTransaction;
import org.web3j.crypto.TransactionDecoder;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.utils.Convert;
import org.web3j.utils.Numeric;

public class EthereumTransaction
extends Transaction {
    public static final BigInteger AMOUNT_MULTIPLIER = BigInteger.valueOf(10000000000L);
    public static final int TYPE_TAG = 18;
    public static final String ERC20_PREFIX = "0xa9059cbb";
    public static final int ADDRESS_LENGTH = 20;
    public static final BigInteger DEFAULT_GAS_PRICE = Convert.toWei((String)"10", (Convert.Unit)Convert.Unit.GWEI).toBigInteger();
    private final BigInteger gasPrice;
    private final Payload payload;
    private final Sign.SignatureData signatureData;
    private static Method encodeMethod;

    public EthereumTransaction(byte chainId, long timestamp, BigInteger gasPrice, long fee, Payload payload, Sign.SignatureData signatureData, PublicKey sender) {
        super(18, 1, chainId, sender, Amount.of(fee), timestamp, Collections.emptyList());
        this.gasPrice = gasPrice;
        this.payload = payload;
        this.signatureData = signatureData;
    }

    public EthereumTransaction(Id id, byte chainId, long timestamp, BigInteger gasPrice, long fee, Payload payload, Sign.SignatureData signatureData, PublicKey sender) {
        super(18, 1, chainId, sender, Amount.of(fee), timestamp, Collections.emptyList());
        this.id = id;
        this.gasPrice = gasPrice;
        this.payload = payload;
        this.signatureData = signatureData;
    }

    @Override
    public Id id() {
        if (this.id == null) {
            return Id.as(Hash.sha3((byte[])this.toBytes()));
        }
        return this.id;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.id().bytes());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EthereumTransaction that = (EthereumTransaction)o;
        return Arrays.equals(this.id().bytes(), that.id().bytes());
    }

    public BigInteger gasPrice() {
        return this.gasPrice;
    }

    public Payload payload() {
        return this.payload;
    }

    public Sign.SignatureData signatureData() {
        return this.signatureData;
    }

    @Override
    public <T extends TransactionOrOrder> T addProof(Proof proof) {
        throw new UnsupportedOperationException("addProof");
    }

    @Override
    public <T extends TransactionOrOrder> T addProof(PrivateKey privateKey) {
        throw new UnsupportedOperationException("addProof");
    }

    @Override
    public <T extends TransactionOrOrder> T addProofs(List<Proof> proofs) {
        throw new UnsupportedOperationException("addProofs");
    }

    @Override
    public <T extends TransactionOrOrder> T setProof(int index, Proof proof) {
        throw new UnsupportedOperationException("setProof");
    }

    @Override
    public <T extends TransactionOrOrder> T setProof(int index, PrivateKey privateKey) {
        throw new UnsupportedOperationException("setProof");
    }

    @Override
    public String toJson() {
        return super.toJson();
    }

    public static byte[] publicKeyBytes(BigInteger publicKey) {
        byte[] publicKeyBytes = publicKey.toByteArray();
        return Arrays.copyOfRange(publicKeyBytes, publicKeyBytes.length - 64, publicKeyBytes.length);
    }

    @Override
    public byte[] toBytes() {
        return EthereumTransaction.encode(this.payload.toRawTransaction(this.timestamp(), this.gasPrice, this.fee().value()), this.signatureData);
    }

    public static byte[] encode(RawTransaction transaction, Sign.SignatureData signatureData) {
        Objects.requireNonNull(encodeMethod, "encode is not available");
        try {
            return (byte[])encodeMethod.invoke(null, transaction, signatureData);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Reflective error while encoding transaction", e);
        }
    }

    public static PublicKey recoverFromSignature(Sign.SignatureData signatureData, byte chainId, RawTransaction rawTransaction) {
        return PublicKey.as(EthereumTransaction.publicKeyBytes(Sign.recoverFromSignature((int)Sign.getRecId((Sign.SignatureData)signatureData, (long)chainId), (ECDSASignature)new ECDSASignature(new BigInteger(1, signatureData.getR()), new BigInteger(1, signatureData.getS())), (byte[])Hash.sha3((byte[])TransactionEncoder.encode((RawTransaction)rawTransaction, (long)chainId)))));
    }

    public static EthereumTransaction transfer(Address recipient, Amount amount, BigInteger gasPrice, byte chainId, long fee, long timestamp, Sign.SignatureData signatureData) {
        Transfer payload = new Transfer(recipient, amount);
        PublicKey sender = EthereumTransaction.recoverFromSignature(signatureData, chainId, payload.toRawTransaction(timestamp, gasPrice, fee));
        return new EthereumTransaction(chainId, timestamp, gasPrice, fee, payload, signatureData, sender);
    }

    public static EthereumTransaction transfer(Address recipient, Amount amount, BigInteger gasPrice, byte chainId, long fee, long timestamp, ECKeyPair keyPair) {
        return EthereumTransaction.createAndSign(new Transfer(recipient, amount), gasPrice, chainId, fee, timestamp, keyPair);
    }

    public static EthereumTransaction invocation(Address dapp, Function function, List<Amount> payments, BigInteger gasPrice, byte chainId, long fee, long timestamp, Sign.SignatureData signatureData) {
        Invocation payload = new Invocation(dapp, function, payments);
        PublicKey sender = EthereumTransaction.recoverFromSignature(signatureData, chainId, payload.toRawTransaction(timestamp, gasPrice, fee));
        return new EthereumTransaction(chainId, timestamp, gasPrice, fee, payload, signatureData, sender);
    }

    public static EthereumTransaction invocation(Address dapp, Function function, List<Amount> payments, BigInteger gasPrice, byte chainId, long fee, long timestamp, ECKeyPair keyPair) {
        return EthereumTransaction.createAndSign(new Invocation(dapp, function, payments), gasPrice, chainId, fee, timestamp, keyPair);
    }

    public static EthereumTransaction createAndSign(Payload payload, BigInteger gasPrice, byte chainId, long fee, long timestamp, ECKeyPair keyPair) {
        RawTransaction rawTransaction = payload.toRawTransaction(timestamp, gasPrice, fee);
        byte[] transactionBytes = TransactionEncoder.encode((RawTransaction)rawTransaction, (long)chainId);
        Sign.SignatureData signatureData = TransactionEncoder.createEip155SignatureData((Sign.SignatureData)Sign.signMessage((byte[])transactionBytes, (ECKeyPair)keyPair), (long)chainId);
        PublicKey sender = PublicKey.as(EthereumTransaction.publicKeyBytes(keyPair.getPublicKey()));
        return new EthereumTransaction(chainId, timestamp, gasPrice, fee, payload, signatureData, sender);
    }

    public static EthereumTransaction parse(String transactionBytesAsHex) {
        SignedRawTransaction srt = (SignedRawTransaction)TransactionDecoder.decode((String)transactionBytesAsHex);
        String data = Numeric.cleanHexPrefix((String)srt.getTransaction().getData());
        if (data.isEmpty() && !srt.getTransaction().getValue().equals(BigInteger.ZERO)) {
            return EthereumTransaction.transfer(Address.fromPart(srt.getChainId().byteValue(), Numeric.hexStringToByteArray((String)srt.getTo())), Amount.of(srt.getValue().divide(AMOUNT_MULTIPLIER).longValueExact()), srt.getGasPrice(), srt.getChainId().byteValue(), srt.getGasLimit().longValueExact(), srt.getNonce().longValueExact(), srt.getSignatureData());
        }
        if (data.startsWith(ERC20_PREFIX) && srt.getTransaction().getValue().equals(BigInteger.ZERO)) {
            return EthereumTransaction.transfer(Address.fromPart(srt.getChainId().byteValue(), Numeric.hexStringToByteArray((String)new org.web3j.abi.datatypes.Address(data.substring(8, 71)).toString())), Amount.of(Numeric.toBigInt((String)data.substring(72)).divide(AMOUNT_MULTIPLIER).longValueExact(), AssetId.as(Numeric.hexStringToByteArray((String)srt.getTo()))), srt.getGasPrice(), srt.getChainId().byteValue(), srt.getGasLimit().longValueExact(), srt.getNonce().longValueExact(), srt.getSignatureData());
        }
        throw new IllegalArgumentException("Could not parse transaction");
    }

    public static EthereumTransaction invokeScriptTxfromProtobuf(TransactionOuterClass.SignedTransaction protobufTx, Events.TransactionMetadata txMetadata) {
        return ProtobufConverter.ethInvokeScriptTxFromProtobuf(protobufTx, txMetadata);
    }

    public static EthereumTransaction transferTxfromProtobuf(TransactionOuterClass.SignedTransaction protobufTx) {
        return ProtobufConverter.ethTransferTxFromProtobuf(protobufTx);
    }

    public static EthereumTransaction parse(byte[] transactionBytes) {
        return EthereumTransaction.parse(Numeric.toHexString((byte[])transactionBytes));
    }

    static {
        try {
            encodeMethod = TransactionEncoder.class.getDeclaredMethod("encode", RawTransaction.class, Sign.SignatureData.class);
            encodeMethod.setAccessible(true);
        }
        catch (NoSuchMethodException nsme) {
            encodeMethod = null;
        }
    }

    public static class Invocation
    implements Payload {
        private final Address dapp;
        private final Function function;
        private final List<Amount> payments;

        public Invocation(Address dapp, Function function, List<Amount> payments) {
            this.dapp = dapp;
            this.function = function;
            this.payments = payments.isEmpty() ? Collections.singletonList(new Amount(0L, null)) : payments;
        }

        public Address dApp() {
            return this.dapp;
        }

        public Function function() {
            return this.function;
        }

        public List<Amount> payments() {
            return this.payments;
        }

        private void addArgs(ArrayList<Type> target, List<Arg> source, boolean allowNesting) {
            for (Arg arg : source) {
                switch (arg.type()) {
                    case BINARY: {
                        target.add((Type)new DynamicBytes(((BinaryArg)arg).value().bytes()));
                        break;
                    }
                    case STRING: {
                        target.add((Type)new Utf8String(((StringArg)arg).value()));
                        break;
                    }
                    case INTEGER: {
                        target.add((Type)new Int64(((IntegerArg)arg).value()));
                        break;
                    }
                    case BOOLEAN: {
                        target.add((Type)new Bool(((BooleanArg)arg).value()));
                        break;
                    }
                    case LIST: {
                        if (!allowNesting) {
                            throw new IllegalArgumentException("Nested lists are not supported");
                        }
                        ArrayList<Type> listValues = new ArrayList<Type>();
                        this.addArgs(listValues, ((ListArg)arg).value(), false);
                        target.add((Type)new DynamicArray(Type.class, listValues));
                    }
                }
            }
        }

        @Override
        public RawTransaction toRawTransaction(long timestamp, BigInteger gasPrice, long fee) {
            ArrayList<Type> params = new ArrayList<Type>();
            this.addArgs(params, this.function.args(), true);
            List encodedPayments = this.payments.stream().map(a -> new StaticStruct(new Type[]{new Bytes32(a.assetId().isWaves() ? new byte[32] : Base58.decode((String)a.assetId().encoded())), new Int64(a.value())})).collect(Collectors.toList());
            params.add((Type)new DynamicArray(StaticStruct.class, encodedPayments));
            org.web3j.abi.datatypes.Function f = new org.web3j.abi.datatypes.Function(this.function.isDefault() ? "default" : this.function.name(), params, Collections.emptyList());
            return RawTransaction.createTransaction((BigInteger)BigInteger.valueOf(timestamp), (BigInteger)gasPrice, (BigInteger)BigInteger.valueOf(fee), (String)Numeric.toHexString((byte[])this.dapp.publicKeyHash()), (String)EthFunctionEncoder.encodeWavesFunctionInEthFmt(f));
        }
    }

    public static class Transfer
    implements Payload {
        private final Address recipient;
        private final Amount amount;

        public Transfer(Address recipient, Amount amount) {
            this.recipient = recipient;
            this.amount = amount;
        }

        public Address recipient() {
            return this.recipient;
        }

        public Amount amount() {
            return this.amount;
        }

        @Override
        public RawTransaction toRawTransaction(long timestamp, BigInteger gasPrice, long fee) {
            if (this.amount.assetId().isWaves()) {
                return RawTransaction.createEtherTransaction((BigInteger)BigInteger.valueOf(timestamp), (BigInteger)gasPrice, (BigInteger)BigInteger.valueOf(fee), (String)Numeric.toHexString((byte[])this.recipient.publicKeyHash()), (BigInteger)BigInteger.valueOf(this.amount.value()).multiply(AMOUNT_MULTIPLIER));
            }
            return RawTransaction.createTransaction((BigInteger)BigInteger.valueOf(timestamp), (BigInteger)gasPrice, (BigInteger)BigInteger.valueOf(fee), (String)Numeric.toHexString((byte[])this.amount.assetId().bytes(), (int)0, (int)20, (boolean)true), (BigInteger)BigInteger.ZERO, (String)(EthereumTransaction.ERC20_PREFIX + TypeEncoder.encode((Type)new org.web3j.abi.datatypes.Address(new BigInteger(1, this.recipient.publicKeyHash()))) + TypeEncoder.encode((Type)new Uint256(this.amount.value()))));
        }
    }

    public static interface Payload {
        public RawTransaction toRawTransaction(long var1, BigInteger var3, long var4);
    }
}

