/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Proof;
import com.wavesplatform.transactions.data.DataEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DataTransaction
extends Transaction {
    public static final int TYPE = 12;
    public static final int LATEST_VERSION = 2;
    public static final long MIN_FEE = 100000L;
    private final List<DataEntry> data;

    public DataTransaction(PublicKey sender, List<DataEntry> data) {
        this(sender, data, WavesConfig.chainId(), Amount.of(0L), System.currentTimeMillis(), 2, Proof.emptyList());
    }

    public DataTransaction(PublicKey sender, List<DataEntry> data, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(12, version, chainId, sender, DataTransaction.calculateFee(data, fee, version), timestamp, proofs);
        this.data = data == null ? Collections.emptyList() : data;
    }

    public static DataTransaction fromBytes(byte[] bytes) throws IOException {
        return (DataTransaction)Transaction.fromBytes(bytes);
    }

    public static DataTransaction fromJson(String json) throws IOException {
        return (DataTransaction)Transaction.fromJson(json);
    }

    public static DataTransactionBuilder builder(List<DataEntry> data) {
        return new DataTransactionBuilder(data);
    }

    public static DataTransactionBuilder builder(DataEntry ... data) {
        return new DataTransactionBuilder(Arrays.asList(data));
    }

    private static Amount calculateFee(List<DataEntry> data, Amount fee, int version) {
        if (fee.value() > 0L) {
            return fee;
        }
        DataTransaction tempTx = new DataTransaction(PublicKey.ZERO, data, WavesConfig.chainId(), Amount.of(100000L), System.currentTimeMillis(), version, Proof.emptyList());
        int payloadSize = tempTx.version() == 1 ? tempTx.bodyBytes().length : tempTx.toProtobuf().getWavesTransaction().getDataTransaction().toByteArray().length;
        long payloadFee = 100000L * (long)(1 + (payloadSize - 1) / 1024);
        return Amount.of(payloadFee);
    }

    public List<DataEntry> data() {
        return this.data;
    }

    public List<String> dataKeys() {
        return this.data.stream().map(DataEntry::key).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataTransaction that = (DataTransaction)o;
        return this.data.equals(that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data);
    }

    public static class DataTransactionBuilder
    extends Transaction.TransactionBuilder<DataTransactionBuilder, DataTransaction> {
        private final List<DataEntry> data;

        protected DataTransactionBuilder(List<DataEntry> data) {
            super(2, 0L);
            this.data = data;
        }

        @Override
        protected DataTransaction _build() {
            Amount calculatedFee = DataTransaction.calculateFee(this.data, this.fee, this.version);
            Amount calculatedFeeWithExtra = Amount.of(calculatedFee.value() + this.extraFee, calculatedFee.assetId());
            return new DataTransaction(this.sender, this.data, this.chainId, calculatedFeeWithExtra, this.timestamp, this.version, Proof.emptyList());
        }
    }
}

