/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.crypto.Bytes;
import com.wavesplatform.crypto.Hash;
import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Alias;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Id;
import com.wavesplatform.transactions.common.Proof;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class CreateAliasTransaction
extends Transaction {
    public static final int TYPE = 10;
    public static final int LATEST_VERSION = 3;
    public static final long MIN_FEE = 100000L;
    private final Alias alias;

    public CreateAliasTransaction(PublicKey sender, String alias) {
        this(sender, alias, WavesConfig.chainId(), Amount.of(100000L), System.currentTimeMillis(), 3, Proof.emptyList());
    }

    public CreateAliasTransaction(PublicKey sender, String alias, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(10, version, chainId, sender, fee, timestamp, proofs);
        this.alias = Alias.as(chainId, alias == null ? "" : alias);
    }

    public static CreateAliasTransaction fromBytes(byte[] bytes) throws IOException {
        return (CreateAliasTransaction)Transaction.fromBytes(bytes);
    }

    public static CreateAliasTransaction fromJson(String json) throws IOException {
        return (CreateAliasTransaction)Transaction.fromJson(json);
    }

    public static CreateAliasTransactionBuilder builder(String alias) {
        return new CreateAliasTransactionBuilder(alias);
    }

    @Override
    public Id id() {
        return this.version() < 3 ? Id.as(Hash.blake((byte[])Bytes.concat((byte[][])new byte[][]{Bytes.of((byte[])new byte[]{(byte)this.type()}), this.alias.bytes()}))) : super.id();
    }

    public Alias alias() {
        return this.alias;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CreateAliasTransaction that = (CreateAliasTransaction)o;
        return this.alias.equals(that.alias);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.alias);
    }

    public static class CreateAliasTransactionBuilder
    extends Transaction.TransactionBuilder<CreateAliasTransactionBuilder, CreateAliasTransaction> {
        private final String alias;

        protected CreateAliasTransactionBuilder(Alias alias) {
            this(alias.name());
            this.chainId(alias.chainId());
        }

        protected CreateAliasTransactionBuilder(String alias) {
            super(3, 100000L);
            this.alias = alias;
        }

        @Override
        protected CreateAliasTransaction _build() {
            return new CreateAliasTransaction(this.sender, this.alias, this.chainId, this.feeWithExtra(), this.timestamp, this.version, Proof.emptyList());
        }
    }
}

