/*
 * Decompiled with CFR 0.152.
 */
package com.wavesplatform.transactions;

import com.wavesplatform.transactions.Transaction;
import com.wavesplatform.transactions.WavesConfig;
import com.wavesplatform.transactions.account.PublicKey;
import com.wavesplatform.transactions.common.Amount;
import com.wavesplatform.transactions.common.Proof;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class BurnTransaction
extends Transaction {
    public static final int TYPE = 6;
    public static final int LATEST_VERSION = 3;
    public static final long MIN_FEE = 100000L;
    private final Amount amount;

    public BurnTransaction(PublicKey sender, Amount amount) {
        this(sender, amount, WavesConfig.chainId(), Amount.of(100000L), System.currentTimeMillis(), 3, Proof.emptyList());
    }

    public BurnTransaction(PublicKey sender, Amount amount, byte chainId, Amount fee, long timestamp, int version, List<Proof> proofs) {
        super(6, version, chainId, sender, fee, timestamp, proofs);
        if (amount.assetId().isWaves()) {
            throw new IllegalArgumentException("Can't be Waves");
        }
        this.amount = amount;
    }

    public static BurnTransaction fromBytes(byte[] bytes) throws IOException {
        return (BurnTransaction)Transaction.fromBytes(bytes);
    }

    public static BurnTransaction fromJson(String json) throws IOException {
        return (BurnTransaction)Transaction.fromJson(json);
    }

    public static BurnTransactionBuilder builder(Amount amount) {
        return new BurnTransactionBuilder(amount);
    }

    public Amount amount() {
        return this.amount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BurnTransaction that = (BurnTransaction)o;
        return this.amount.equals(that.amount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.amount);
    }

    public static class BurnTransactionBuilder
    extends Transaction.TransactionBuilder<BurnTransactionBuilder, BurnTransaction> {
        private final Amount amount;

        protected BurnTransactionBuilder(Amount amount) {
            super(3, 100000L);
            this.amount = amount;
        }

        @Override
        protected BurnTransaction _build() {
            return new BurnTransaction(this.sender, this.amount, this.chainId, this.feeWithExtra(), this.timestamp, this.version, Proof.emptyList());
        }
    }
}

