/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.curve25519.java;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import org.whispersystems.curve25519.java.Sha512;
import org.whispersystems.curve25519.java.elligator;
import org.whispersystems.curve25519.java.ge_double_scalarmult;
import org.whispersystems.curve25519.java.ge_frombytes;
import org.whispersystems.curve25519.java.ge_isneutral;
import org.whispersystems.curve25519.java.ge_neg;
import org.whispersystems.curve25519.java.ge_p2;
import org.whispersystems.curve25519.java.ge_p3;
import org.whispersystems.curve25519.java.ge_p3_tobytes;
import org.whispersystems.curve25519.java.ge_scalarmult;
import org.whispersystems.curve25519.java.ge_scalarmult_base;
import org.whispersystems.curve25519.java.ge_scalarmult_cofactor;
import org.whispersystems.curve25519.java.ge_tobytes;
import org.whispersystems.curve25519.java.point_isreduced;
import org.whispersystems.curve25519.java.sc_isreduced;
import org.whispersystems.curve25519.java.sc_muladd;
import org.whispersystems.curve25519.java.sc_reduce;

public class veddsa {
    static final int BLOCKLEN = 128;
    static final int HASHLEN = 64;
    static final int RANDLEN = 32;
    static final int MSTART = 2048;
    static final int MSGMAXLEN = 0x100000;
    static final int BUFLEN = 1024;
    static final int VRFOUTPUTLEN = 32;
    static final int LABELSETMAXLEN = 512;
    static final int LABELMAXLEN = 127;
    public static final byte[] B_bytes = new byte[]{88, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102};

    private static byte[] labelset_new(String protocol_name, byte[] customization_label, byte label) {
        if (512 < 3 + protocol_name.length() + customization_label.length + 2) {
            return null;
        }
        if (protocol_name.length() > 127) {
            return null;
        }
        if (customization_label.length > 127) {
            return null;
        }
        byte[] protocol_name_bytes = protocol_name.getBytes();
        ByteBuffer bb = ByteBuffer.allocate(3 + protocol_name_bytes.length + customization_label.length + 2);
        bb.put((byte)3);
        bb.put((byte)protocol_name_bytes.length);
        bb.put(protocol_name_bytes);
        bb.put((byte)customization_label.length);
        bb.put(customization_label);
        assert (bb.position() == 3 + protocol_name.length() + customization_label.length);
        bb.put((byte)1);
        bb.put(label);
        assert (bb.position() < 512);
        return bb.array();
    }

    private static boolean generalized_commit(Sha512 sha512provider, byte[] R_bytes, byte[] r_scalar, byte[] labelset, byte[] extra, int extra_len, byte[] K_bytes, byte[] k_scalar, byte[] Z, byte[] message) {
        ge_p3 R_point = new ge_p3();
        byte[] hash = new byte[64];
        if (R_bytes == null || R_bytes.length != 32) {
            return false;
        }
        if (r_scalar == null || r_scalar.length != 32) {
            return false;
        }
        if (K_bytes == null || K_bytes.length != 32) {
            return false;
        }
        if (k_scalar == null || k_scalar.length != 32) {
            return false;
        }
        if (Z == null || Z.length != 32) {
            return false;
        }
        if (extra == null || extra.length == 0) {
            return false;
        }
        int prefix_len = 0;
        int pad_len1 = (128 - (prefix_len += 32 + labelset.length + 32) % 128) % 128;
        prefix_len += pad_len1;
        int pad_len2 = (128 - (prefix_len += 32) % 128) % 128;
        MessageDigest md = sha512provider.initDigest();
        sha512provider.updateDigest(md, B_bytes, 32L);
        sha512provider.updateDigest(md, labelset, labelset.length);
        sha512provider.updateDigest(md, Z, 32L);
        sha512provider.updateDigest(md, new byte[pad_len1], pad_len1);
        sha512provider.updateDigest(md, k_scalar, 32L);
        sha512provider.updateDigest(md, new byte[pad_len2], pad_len2);
        sha512provider.updateDigest(md, labelset, labelset.length);
        sha512provider.updateDigest(md, K_bytes, 32L);
        sha512provider.updateDigest(md, extra, extra_len);
        sha512provider.updateDigest(md, message, message.length);
        sha512provider.finishDigest(hash, md);
        sc_reduce.sc_reduce(hash);
        ge_scalarmult_base.ge_scalarmult_base(R_point, hash);
        ge_p3_tobytes.ge_p3_tobytes(R_bytes, R_point);
        System.arraycopy(hash, 0, r_scalar, 0, 32);
        return true;
    }

    private static boolean generalized_challenge(Sha512 sha512provider, byte[] h_scalar, byte[] labelset, byte[] extra, byte[] R_bytes, byte[] K_bytes, byte[] message) {
        byte[] hash = new byte[64];
        if (h_scalar == null || h_scalar.length != 32) {
            return false;
        }
        if (R_bytes == null || R_bytes.length != 32) {
            return false;
        }
        if (K_bytes == null || K_bytes.length != 32) {
            return false;
        }
        if (extra == null) {
            return false;
        }
        MessageDigest md = sha512provider.initDigest();
        sha512provider.updateDigest(md, B_bytes, 32L);
        sha512provider.updateDigest(md, labelset, labelset.length);
        sha512provider.updateDigest(md, R_bytes, 32L);
        sha512provider.updateDigest(md, labelset, labelset.length);
        sha512provider.updateDigest(md, K_bytes, 32L);
        sha512provider.updateDigest(md, extra, extra.length);
        sha512provider.updateDigest(md, message, message.length);
        sha512provider.finishDigest(hash, md);
        sc_reduce.sc_reduce(hash);
        System.arraycopy(hash, 0, h_scalar, 0, 32);
        return true;
    }

    private static boolean generalized_prove(byte[] out_scalar, byte[] r_scalar, byte[] k_scalar, byte[] h_scalar) {
        if (out_scalar == null || out_scalar.length != 32) {
            return false;
        }
        if (r_scalar == null || r_scalar.length != 32) {
            return false;
        }
        if (k_scalar == null || k_scalar.length != 32) {
            return false;
        }
        if (h_scalar == null || h_scalar.length != 32) {
            return false;
        }
        sc_muladd.sc_muladd(out_scalar, h_scalar, k_scalar, r_scalar);
        return true;
    }

    private static boolean generalized_solve_commitment(byte[] R_bytes_out, ge_p3 K_point_out, ge_p3 B_point, byte[] s_scalar, byte[] K_bytes, byte[] h_scalar) {
        if (R_bytes_out == null || R_bytes_out.length != 32) {
            return false;
        }
        if (s_scalar == null || s_scalar.length != 32) {
            return false;
        }
        if (K_bytes == null || K_bytes.length != 32) {
            return false;
        }
        if (h_scalar == null || h_scalar.length != 32) {
            return false;
        }
        ge_p3 Kneg_point = new ge_p3();
        ge_p2 R_calc_point_p2 = new ge_p2();
        if (ge_frombytes.ge_frombytes_negate_vartime(Kneg_point, K_bytes) != 0) {
            return false;
        }
        ge_double_scalarmult.ge_double_scalarmult_vartime(R_calc_point_p2, h_scalar, Kneg_point, s_scalar, B_point);
        ge_tobytes.ge_tobytes(R_bytes_out, R_calc_point_p2);
        if (K_point_out != null) {
            ge_neg.ge_neg(K_point_out, Kneg_point);
        }
        return true;
    }

    private static boolean generalized_calculate_Bv(Sha512 sha512provider, ge_p3 Bv_point, byte[] labelset, byte[] K_bytes, byte[] M_buf, int M_start, int M_len) {
        if (Bv_point == null || K_bytes == null || M_buf == null) {
            return false;
        }
        int prefix_len = 64 + labelset.length;
        if (prefix_len > M_start) {
            return false;
        }
        int startIndex = M_start - prefix_len;
        System.arraycopy(B_bytes, 0, M_buf, startIndex, 32);
        System.arraycopy(labelset, 0, M_buf, startIndex + 32, labelset.length);
        System.arraycopy(K_bytes, 0, M_buf, startIndex + 32 + labelset.length, 32);
        byte[] in = Arrays.copyOfRange(M_buf, startIndex, M_start + M_len);
        System.arraycopy(M_buf, M_start, in, in.length - M_len, M_len);
        elligator.hash_to_point(sha512provider, Bv_point, in);
        return true;
    }

    private static boolean generalized_calculate_vrf_output(Sha512 sha512provider, byte[] vrf_output, byte[] labelset, ge_p3 cKv_point) {
        byte[] cKv_bytes = new byte[32];
        byte[] hash = new byte[64];
        if (vrf_output == null || vrf_output.length != 32) {
            return false;
        }
        if (labelset.length + 64 > 1024) {
            return false;
        }
        if (cKv_point == null) {
            return false;
        }
        ge_p3_tobytes.ge_p3_tobytes(cKv_bytes, cKv_point);
        MessageDigest md = sha512provider.initDigest();
        sha512provider.updateDigest(md, B_bytes, 32L);
        sha512provider.updateDigest(md, labelset, labelset.length);
        sha512provider.updateDigest(md, cKv_bytes, cKv_bytes.length);
        sha512provider.finishDigest(hash, md);
        System.arraycopy(hash, 0, vrf_output, 0, 32);
        return true;
    }

    static boolean generalized_veddsa_25519_sign(Sha512 sha512provider, byte[] signature_out, byte[] eddsa_25519_pubkey_bytes, byte[] eddsa_25519_privkey_scalar, byte[] msg, byte[] random, byte[] customization_label) {
        if (signature_out == null || signature_out.length != 96) {
            return false;
        }
        if (eddsa_25519_pubkey_bytes == null) {
            return false;
        }
        if (eddsa_25519_privkey_scalar == null) {
            return false;
        }
        if (customization_label == null || customization_label.length > 127) {
            return false;
        }
        if (msg == null || msg.length > 0x100000) {
            return false;
        }
        ge_p3 Bv_point = new ge_p3();
        ge_p3 Kv_point = new ge_p3();
        ge_p3 Rv_point = new ge_p3();
        byte[] Bv_bytes = new byte[32];
        byte[] Kv_bytes = new byte[32];
        byte[] Rv_bytes = new byte[32];
        byte[] R_bytes = new byte[32];
        byte[] r_scalar = new byte[32];
        byte[] h_scalar = new byte[32];
        byte[] s_scalar = new byte[32];
        byte[] extra = new byte[96];
        byte[] M_buf = new byte[msg.length + 2048];
        String protocol_name = "VEdDSA_25519_SHA512_Elligator2";
        System.arraycopy(msg, 0, M_buf, 2048, msg.length);
        byte[] labelset = veddsa.labelset_new(protocol_name, customization_label, (byte)49);
        if (labelset == null) {
            return false;
        }
        veddsa.generalized_calculate_Bv(sha512provider, Bv_point, labelset, eddsa_25519_pubkey_bytes, M_buf, 2048, msg.length);
        ge_scalarmult.ge_scalarmult(Kv_point, eddsa_25519_privkey_scalar, Bv_point);
        ge_p3_tobytes.ge_p3_tobytes(Bv_bytes, Bv_point);
        ge_p3_tobytes.ge_p3_tobytes(Kv_bytes, Kv_point);
        labelset[labelset.length - 1] = 50;
        System.arraycopy(Bv_bytes, 0, extra, 0, 32);
        System.arraycopy(Kv_bytes, 0, extra, 32, 32);
        if (!veddsa.generalized_commit(sha512provider, R_bytes, r_scalar, labelset, extra, 64, eddsa_25519_pubkey_bytes, eddsa_25519_privkey_scalar, random, msg)) {
            return false;
        }
        ge_scalarmult.ge_scalarmult(Rv_point, r_scalar, Bv_point);
        ge_p3_tobytes.ge_p3_tobytes(Rv_bytes, Rv_point);
        labelset[labelset.length - 1] = 51;
        System.arraycopy(Rv_bytes, 0, extra, 64, 32);
        if (!veddsa.generalized_challenge(sha512provider, h_scalar, labelset, extra, R_bytes, eddsa_25519_pubkey_bytes, msg)) {
            return false;
        }
        if (!veddsa.generalized_prove(s_scalar, r_scalar, eddsa_25519_privkey_scalar, h_scalar)) {
            return false;
        }
        System.arraycopy(Kv_bytes, 0, signature_out, 0, 32);
        System.arraycopy(h_scalar, 0, signature_out, 32, 32);
        System.arraycopy(s_scalar, 0, signature_out, 64, 32);
        return true;
    }

    static boolean generalized_veddsa_25519_verify(Sha512 sha512provider, byte[] vrf_output, byte[] signature, byte[] eddsa_25519_pubkey_bytes, byte[] msg, byte[] customization_label) {
        if (signature == null || signature.length != 96) {
            return false;
        }
        if (eddsa_25519_pubkey_bytes == null || eddsa_25519_pubkey_bytes.length != 32) {
            return false;
        }
        if (msg == null || msg.length > 0x100000) {
            return false;
        }
        if (customization_label == null || customization_label.length > 127) {
            return false;
        }
        if (vrf_output == null || vrf_output.length != 32) {
            return false;
        }
        ge_p3 Bv_point = new ge_p3();
        ge_p3 K_point = new ge_p3();
        ge_p3 Kv_point = new ge_p3();
        ge_p3 cK_point = new ge_p3();
        ge_p3 cKv_point = new ge_p3();
        byte[] Bv_bytes = new byte[32];
        byte[] R_calc_bytes = new byte[32];
        byte[] Rv_calc_bytes = new byte[32];
        byte[] h_calc_scalar = new byte[32];
        byte[] extra = new byte[96];
        String protocol_name = "VEdDSA_25519_SHA512_Elligator2";
        byte[] M_buf = new byte[msg.length + 2048];
        System.arraycopy(msg, 0, M_buf, 2048, msg.length);
        byte[] Kv_bytes = new byte[32];
        System.arraycopy(signature, 0, Kv_bytes, 0, 32);
        byte[] h_scalar = new byte[32];
        System.arraycopy(signature, 32, h_scalar, 0, 32);
        byte[] s_scalar = new byte[32];
        System.arraycopy(signature, 64, s_scalar, 0, 32);
        if (!point_isreduced.point_isreduced(eddsa_25519_pubkey_bytes)) {
            return false;
        }
        if (!point_isreduced.point_isreduced(Kv_bytes)) {
            return false;
        }
        if (!sc_isreduced.sc_isreduced(h_scalar)) {
            return false;
        }
        if (!sc_isreduced.sc_isreduced(s_scalar)) {
            return false;
        }
        byte[] labelset = veddsa.labelset_new(protocol_name, customization_label, (byte)49);
        if (labelset == null) {
            return false;
        }
        if (!veddsa.generalized_calculate_Bv(sha512provider, Bv_point, labelset, eddsa_25519_pubkey_bytes, M_buf, 2048, msg.length)) {
            return false;
        }
        ge_p3_tobytes.ge_p3_tobytes(Bv_bytes, Bv_point);
        if (!veddsa.generalized_solve_commitment(R_calc_bytes, K_point, null, s_scalar, eddsa_25519_pubkey_bytes, h_scalar)) {
            return false;
        }
        if (!veddsa.generalized_solve_commitment(Rv_calc_bytes, Kv_point, Bv_point, s_scalar, Kv_bytes, h_scalar)) {
            return false;
        }
        ge_scalarmult_cofactor.ge_scalarmult_cofactor(cK_point, K_point);
        ge_scalarmult_cofactor.ge_scalarmult_cofactor(cKv_point, Kv_point);
        if (ge_isneutral.ge_isneutral(cK_point) || ge_isneutral.ge_isneutral(cKv_point) || ge_isneutral.ge_isneutral(Bv_point)) {
            return false;
        }
        labelset[labelset.length - 1] = 51;
        System.arraycopy(Bv_bytes, 0, extra, 0, 32);
        System.arraycopy(Kv_bytes, 0, extra, 32, 32);
        System.arraycopy(Rv_calc_bytes, 0, extra, 64, 32);
        if (!veddsa.generalized_challenge(sha512provider, h_calc_scalar, labelset, extra, R_calc_bytes, eddsa_25519_pubkey_bytes, msg)) {
            return false;
        }
        if (!Arrays.equals(h_scalar, h_calc_scalar)) {
            return false;
        }
        labelset[labelset.length - 1] = 52;
        return veddsa.generalized_calculate_vrf_output(sha512provider, vrf_output, labelset, cKv_point);
    }
}

