/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.curve25519.java;

import org.whispersystems.curve25519.java.Sha512;
import org.whispersystems.curve25519.java.fe_isreduced;
import org.whispersystems.curve25519.java.fe_montx_to_edy;
import org.whispersystems.curve25519.java.fe_tobytes;
import org.whispersystems.curve25519.java.ge_p3;
import org.whispersystems.curve25519.java.ge_p3_tobytes;
import org.whispersystems.curve25519.java.ge_scalarmult_base;
import org.whispersystems.curve25519.java.sc_cmov;
import org.whispersystems.curve25519.java.sc_neg;
import org.whispersystems.curve25519.java.veddsa;

public class gen_x {
    public static final int SCALARLEN = 32;
    public static final int POINTLEN = 32;

    public static boolean convert_25519_pubkey(byte[] ed_pubkey_bytes, byte[] x25519_pubkey_bytes) {
        int[] u = fe_isreduced.fe_isreduced(x25519_pubkey_bytes);
        if (u == null) {
            return false;
        }
        int[] y = new int[10];
        fe_montx_to_edy.fe_montx_to_edy(y, u);
        fe_tobytes.fe_tobytes(ed_pubkey_bytes, y);
        return true;
    }

    public static void calculate_25519_keypair(byte[] K_bytes, byte[] k_scalar, byte[] x25519_privkey_scalar) {
        byte[] kneg = new byte[32];
        ge_p3 ed_pubkey_point = new ge_p3();
        ge_scalarmult_base.ge_scalarmult_base(ed_pubkey_point, x25519_privkey_scalar);
        ge_p3_tobytes.ge_p3_tobytes(K_bytes, ed_pubkey_point);
        byte sign_bit = (byte)((K_bytes[31] & 0x80) >> 7);
        System.arraycopy(x25519_privkey_scalar, 0, k_scalar, 0, 32);
        sc_neg.sc_neg(kneg, k_scalar);
        sc_cmov.sc_cmov(k_scalar, kneg, sign_bit);
        K_bytes[31] = (byte)(K_bytes[31] & 0x7F);
    }

    public static boolean generalized_xveddsa_25519_sign(Sha512 sha512provider, byte[] signature_out, byte[] x25519_privkey_scalar, byte[] msg, byte[] random) {
        byte[] K_bytes = new byte[32];
        byte[] k_scalar = new byte[32];
        gen_x.calculate_25519_keypair(K_bytes, k_scalar, x25519_privkey_scalar);
        boolean retval = veddsa.generalized_veddsa_25519_sign(sha512provider, signature_out, K_bytes, k_scalar, msg, random, new byte[0]);
        return retval;
    }

    public static boolean generalized_xveddsa_25519_verify(Sha512 sha512provider, byte[] vrf_output, byte[] signature, byte[] x25519_pubkey_bytes, byte[] msg) {
        byte[] K_bytes = new byte[32];
        if (!gen_x.convert_25519_pubkey(K_bytes, x25519_pubkey_bytes)) {
            return false;
        }
        return veddsa.generalized_veddsa_25519_verify(sha512provider, vrf_output, signature, K_bytes, msg, new byte[0]);
    }
}

